/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExportableAutoScalingGroupField {
    ACCOUNT_ID("AccountId"),

    AUTO_SCALING_GROUP_ARN("AutoScalingGroupArn"),

    AUTO_SCALING_GROUP_NAME("AutoScalingGroupName"),

    FINDING("Finding"),

    UTILIZATION_METRICS_CPU_MAXIMUM("UtilizationMetricsCpuMaximum"),

    UTILIZATION_METRICS_MEMORY_MAXIMUM("UtilizationMetricsMemoryMaximum"),

    UTILIZATION_METRICS_EBS_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsReadBytesPerSecondMaximum"),

    UTILIZATION_METRICS_EBS_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsEbsWriteBytesPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_READ_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadOpsPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_WRITE_OPS_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteOpsPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_READ_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskReadBytesPerSecondMaximum"),

    UTILIZATION_METRICS_DISK_WRITE_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsDiskWriteBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_IN_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkInBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_OUT_BYTES_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkOutBytesPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_PACKETS_IN_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsInPerSecondMaximum"),

    UTILIZATION_METRICS_NETWORK_PACKETS_OUT_PER_SECOND_MAXIMUM("UtilizationMetricsNetworkPacketsOutPerSecondMaximum"),

    LOOKBACK_PERIOD_IN_DAYS("LookbackPeriodInDays"),

    CURRENT_CONFIGURATION_INSTANCE_TYPE("CurrentConfigurationInstanceType"),

    CURRENT_CONFIGURATION_DESIRED_CAPACITY("CurrentConfigurationDesiredCapacity"),

    CURRENT_CONFIGURATION_MIN_SIZE("CurrentConfigurationMinSize"),

    CURRENT_CONFIGURATION_MAX_SIZE("CurrentConfigurationMaxSize"),

    CURRENT_ON_DEMAND_PRICE("CurrentOnDemandPrice"),

    CURRENT_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardOneYearNoUpfrontReservedPrice"),

    CURRENT_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE("CurrentStandardThreeYearNoUpfrontReservedPrice"),

    CURRENT_V_CPUS("CurrentVCpus"),

    CURRENT_MEMORY("CurrentMemory"),

    CURRENT_STORAGE("CurrentStorage"),

    CURRENT_NETWORK("CurrentNetwork"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_INSTANCE_TYPE("RecommendationOptionsConfigurationInstanceType"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_DESIRED_CAPACITY("RecommendationOptionsConfigurationDesiredCapacity"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_MIN_SIZE("RecommendationOptionsConfigurationMinSize"),

    RECOMMENDATION_OPTIONS_CONFIGURATION_MAX_SIZE("RecommendationOptionsConfigurationMaxSize"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_CPU_MAXIMUM("RecommendationOptionsProjectedUtilizationMetricsCpuMaximum"),

    RECOMMENDATION_OPTIONS_PROJECTED_UTILIZATION_METRICS_MEMORY_MAXIMUM(
            "RecommendationOptionsProjectedUtilizationMetricsMemoryMaximum"),

    RECOMMENDATION_OPTIONS_PERFORMANCE_RISK("RecommendationOptionsPerformanceRisk"),

    RECOMMENDATION_OPTIONS_ON_DEMAND_PRICE("RecommendationOptionsOnDemandPrice"),

    RECOMMENDATION_OPTIONS_STANDARD_ONE_YEAR_NO_UPFRONT_RESERVED_PRICE(
            "RecommendationOptionsStandardOneYearNoUpfrontReservedPrice"),

    RECOMMENDATION_OPTIONS_STANDARD_THREE_YEAR_NO_UPFRONT_RESERVED_PRICE(
            "RecommendationOptionsStandardThreeYearNoUpfrontReservedPrice"),

    RECOMMENDATION_OPTIONS_VCPUS("RecommendationOptionsVcpus"),

    RECOMMENDATION_OPTIONS_MEMORY("RecommendationOptionsMemory"),

    RECOMMENDATION_OPTIONS_STORAGE("RecommendationOptionsStorage"),

    RECOMMENDATION_OPTIONS_NETWORK("RecommendationOptionsNetwork"),

    LAST_REFRESH_TIMESTAMP("LastRefreshTimestamp"),

    CURRENT_PERFORMANCE_RISK("CurrentPerformanceRisk"),

    RECOMMENDATION_OPTIONS_SAVINGS_OPPORTUNITY_PERCENTAGE("RecommendationOptionsSavingsOpportunityPercentage"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_CURRENCY("RecommendationOptionsEstimatedMonthlySavingsCurrency"),

    RECOMMENDATION_OPTIONS_ESTIMATED_MONTHLY_SAVINGS_VALUE("RecommendationOptionsEstimatedMonthlySavingsValue"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_CPU_VENDOR_ARCHITECTURES("EffectiveRecommendationPreferencesCpuVendorArchitectures"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_ENHANCED_INFRASTRUCTURE_METRICS(
            "EffectiveRecommendationPreferencesEnhancedInfrastructureMetrics"),

    EFFECTIVE_RECOMMENDATION_PREFERENCES_INFERRED_WORKLOAD_TYPES("EffectiveRecommendationPreferencesInferredWorkloadTypes"),

    INFERRED_WORKLOAD_TYPES("InferredWorkloadTypes"),

    RECOMMENDATION_OPTIONS_MIGRATION_EFFORT("RecommendationOptionsMigrationEffort"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportableAutoScalingGroupField> VALUE_MAP = EnumUtils.uniqueIndex(
            ExportableAutoScalingGroupField.class, ExportableAutoScalingGroupField::toString);

    private final String value;

    private ExportableAutoScalingGroupField(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExportableAutoScalingGroupField corresponding to the value
     */
    public static ExportableAutoScalingGroupField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExportableAutoScalingGroupField}s
     */
    public static Set<ExportableAutoScalingGroupField> knownValues() {
        Set<ExportableAutoScalingGroupField> knownValues = EnumSet.allOf(ExportableAutoScalingGroupField.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
