/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a projected utilization metric of an Lambda function recommendation option.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionMemoryProjectedMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionMemoryProjectedMetric.Builder, LambdaFunctionMemoryProjectedMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(LambdaFunctionMemoryProjectedMetric::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statistic").getter(getter(LambdaFunctionMemoryProjectedMetric::statisticAsString))
            .setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistic").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("value")
            .getter(getter(LambdaFunctionMemoryProjectedMetric::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATISTIC_FIELD,
            VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String statistic;

    private final Double value;

    private LambdaFunctionMemoryProjectedMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.statistic = builder.statistic;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link LambdaFunctionMemoryMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the projected utilization metric.
     * @see LambdaFunctionMemoryMetricName
     */
    public final LambdaFunctionMemoryMetricName name() {
        return LambdaFunctionMemoryMetricName.fromValue(name);
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link LambdaFunctionMemoryMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the projected utilization metric.
     * @see LambdaFunctionMemoryMetricName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The statistic of the projected utilization metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link LambdaFunctionMemoryMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic of the projected utilization metric.
     * @see LambdaFunctionMemoryMetricStatistic
     */
    public final LambdaFunctionMemoryMetricStatistic statistic() {
        return LambdaFunctionMemoryMetricStatistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic of the projected utilization metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link LambdaFunctionMemoryMetricStatistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic of the projected utilization metric.
     * @see LambdaFunctionMemoryMetricStatistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     * 
     * @return The values of the projected utilization metrics.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionMemoryProjectedMetric)) {
            return false;
        }
        LambdaFunctionMemoryProjectedMetric other = (LambdaFunctionMemoryProjectedMetric) obj;
        return Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(statisticAsString(), other.statisticAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaFunctionMemoryProjectedMetric").add("Name", nameAsString())
                .add("Statistic", statisticAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionMemoryProjectedMetric, T> g) {
        return obj -> g.apply((LambdaFunctionMemoryProjectedMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionMemoryProjectedMetric> {
        /**
         * <p>
         * The name of the projected utilization metric.
         * </p>
         * 
         * @param name
         *        The name of the projected utilization metric.
         * @see LambdaFunctionMemoryMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionMemoryMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the projected utilization metric.
         * </p>
         * 
         * @param name
         *        The name of the projected utilization metric.
         * @see LambdaFunctionMemoryMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionMemoryMetricName
         */
        Builder name(LambdaFunctionMemoryMetricName name);

        /**
         * <p>
         * The statistic of the projected utilization metric.
         * </p>
         * 
         * @param statistic
         *        The statistic of the projected utilization metric.
         * @see LambdaFunctionMemoryMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionMemoryMetricStatistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic of the projected utilization metric.
         * </p>
         * 
         * @param statistic
         *        The statistic of the projected utilization metric.
         * @see LambdaFunctionMemoryMetricStatistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LambdaFunctionMemoryMetricStatistic
         */
        Builder statistic(LambdaFunctionMemoryMetricStatistic statistic);

        /**
         * <p>
         * The values of the projected utilization metrics.
         * </p>
         * 
         * @param value
         *        The values of the projected utilization metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String statistic;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionMemoryProjectedMetric model) {
            name(model.name);
            statistic(model.statistic);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(LambdaFunctionMemoryMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(LambdaFunctionMemoryMetricStatistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public LambdaFunctionMemoryProjectedMetric build() {
            return new LambdaFunctionMemoryProjectedMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
