/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.UseCase;

public class ListUseCasesPublisher
implements SdkPublisher<ListUseCasesResponse> {
    private final ConnectAsyncClient client;
    private final ListUseCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUseCasesPublisher(ConnectAsyncClient client, ListUseCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUseCasesPublisher(ConnectAsyncClient client, ListUseCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUseCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUseCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UseCase> useCaseSummaryList() {
        Function<ListUseCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.useCaseSummaryList() != null) {
                return response.useCaseSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUseCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUseCasesResponseFetcher
    implements AsyncPageFetcher<ListUseCasesResponse> {
        private ListUseCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListUseCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUseCasesResponse> nextPage(ListUseCasesResponse previousPage) {
            if (previousPage == null) {
                return ListUseCasesPublisher.this.client.listUseCases(ListUseCasesPublisher.this.firstRequest);
            }
            return ListUseCasesPublisher.this.client.listUseCases((ListUseCasesRequest)((Object)ListUseCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

