/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a routing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingProfile implements SdkPojo, Serializable, ToCopyableBuilder<RoutingProfile.Builder, RoutingProfile> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(RoutingProfile::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(RoutingProfile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileArn").getter(getter(RoutingProfile::routingProfileArn))
            .setter(setter(Builder::routingProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileArn").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(RoutingProfile::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(RoutingProfile::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField
            .<List<MediaConcurrency>> builder(MarshallingType.LIST)
            .memberName("MediaConcurrencies")
            .getter(getter(RoutingProfile::mediaConcurrencies))
            .setter(setter(Builder::mediaConcurrencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConcurrency> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConcurrency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOutboundQueueId").getter(getter(RoutingProfile::defaultOutboundQueueId))
            .setter(setter(Builder::defaultOutboundQueueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(RoutingProfile::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_QUEUES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfAssociatedQueues").getter(getter(RoutingProfile::numberOfAssociatedQueues))
            .setter(setter(Builder::numberOfAssociatedQueues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedQueues").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_USERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfAssociatedUsers").getter(getter(RoutingProfile::numberOfAssociatedUsers))
            .setter(setter(Builder::numberOfAssociatedUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfAssociatedUsers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD,
            ROUTING_PROFILE_ARN_FIELD, ROUTING_PROFILE_ID_FIELD, DESCRIPTION_FIELD, MEDIA_CONCURRENCIES_FIELD,
            DEFAULT_OUTBOUND_QUEUE_ID_FIELD, TAGS_FIELD, NUMBER_OF_ASSOCIATED_QUEUES_FIELD, NUMBER_OF_ASSOCIATED_USERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final String name;

    private final String routingProfileArn;

    private final String routingProfileId;

    private final String description;

    private final List<MediaConcurrency> mediaConcurrencies;

    private final String defaultOutboundQueueId;

    private final Map<String, String> tags;

    private final Long numberOfAssociatedQueues;

    private final Long numberOfAssociatedUsers;

    private RoutingProfile(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.routingProfileArn = builder.routingProfileArn;
        this.routingProfileId = builder.routingProfileId;
        this.description = builder.description;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.tags = builder.tags;
        this.numberOfAssociatedQueues = builder.numberOfAssociatedQueues;
        this.numberOfAssociatedUsers = builder.numberOfAssociatedUsers;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the routing profile.
     * </p>
     * 
     * @return The name of the routing profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the routing profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the routing profile.
     */
    public final String routingProfileArn() {
        return routingProfileArn;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * The description of the routing profile.
     * </p>
     * 
     * @return The description of the routing profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaConcurrencies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaConcurrencies() {
        return mediaConcurrencies != null && !(mediaConcurrencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaConcurrencies} method.
     * </p>
     * 
     * @return The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
     */
    public final List<MediaConcurrency> mediaConcurrencies() {
        return mediaConcurrencies;
    }

    /**
     * <p>
     * The identifier of the default outbound queue for this routing profile.
     * </p>
     * 
     * @return The identifier of the default outbound queue for this routing profile.
     */
    public final String defaultOutboundQueueId() {
        return defaultOutboundQueueId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of associated queues in routing profile.
     * </p>
     * 
     * @return The number of associated queues in routing profile.
     */
    public final Long numberOfAssociatedQueues() {
        return numberOfAssociatedQueues;
    }

    /**
     * <p>
     * The number of associated users in routing profile.
     * </p>
     * 
     * @return The number of associated users in routing profile.
     */
    public final Long numberOfAssociatedUsers() {
        return numberOfAssociatedUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaConcurrencies() ? mediaConcurrencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedQueues());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedUsers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfile)) {
            return false;
        }
        RoutingProfile other = (RoutingProfile) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(name(), other.name())
                && Objects.equals(routingProfileArn(), other.routingProfileArn())
                && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(description(), other.description()) && hasMediaConcurrencies() == other.hasMediaConcurrencies()
                && Objects.equals(mediaConcurrencies(), other.mediaConcurrencies())
                && Objects.equals(defaultOutboundQueueId(), other.defaultOutboundQueueId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(numberOfAssociatedQueues(), other.numberOfAssociatedQueues())
                && Objects.equals(numberOfAssociatedUsers(), other.numberOfAssociatedUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingProfile").add("InstanceId", instanceId()).add("Name", name())
                .add("RoutingProfileArn", routingProfileArn()).add("RoutingProfileId", routingProfileId())
                .add("Description", description())
                .add("MediaConcurrencies", hasMediaConcurrencies() ? mediaConcurrencies() : null)
                .add("DefaultOutboundQueueId", defaultOutboundQueueId()).add("Tags", hasTags() ? tags() : null)
                .add("NumberOfAssociatedQueues", numberOfAssociatedQueues())
                .add("NumberOfAssociatedUsers", numberOfAssociatedUsers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoutingProfileArn":
            return Optional.ofNullable(clazz.cast(routingProfileArn()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MediaConcurrencies":
            return Optional.ofNullable(clazz.cast(mediaConcurrencies()));
        case "DefaultOutboundQueueId":
            return Optional.ofNullable(clazz.cast(defaultOutboundQueueId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NumberOfAssociatedQueues":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedQueues()));
        case "NumberOfAssociatedUsers":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfile, T> g) {
        return obj -> g.apply((RoutingProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingProfile> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the routing profile.
         * </p>
         * 
         * @param name
         *        The name of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the routing profile.
         * </p>
         * 
         * @param routingProfileArn
         *        The Amazon Resource Name (ARN) of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileArn(String routingProfileArn);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The description of the routing profile.
         * </p>
         * 
         * @param description
         *        The description of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * 
         * @param mediaConcurrencies
         *        The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies);

        /**
         * <p>
         * The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.MediaConcurrency#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaConcurrencies(List<MediaConcurrency>)}.
         * 
         * @param mediaConcurrencies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MediaConcurrency.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConcurrencies(java.util.Collection<MediaConcurrency>)
         */
        Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies);

        /**
         * <p>
         * The identifier of the default outbound queue for this routing profile.
         * </p>
         * 
         * @param defaultOutboundQueueId
         *        The identifier of the default outbound queue for this routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundQueueId(String defaultOutboundQueueId);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The number of associated queues in routing profile.
         * </p>
         * 
         * @param numberOfAssociatedQueues
         *        The number of associated queues in routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedQueues(Long numberOfAssociatedQueues);

        /**
         * <p>
         * The number of associated users in routing profile.
         * </p>
         * 
         * @param numberOfAssociatedUsers
         *        The number of associated users in routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedUsers(Long numberOfAssociatedUsers);
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private String name;

        private String routingProfileArn;

        private String routingProfileId;

        private String description;

        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();

        private String defaultOutboundQueueId;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Long numberOfAssociatedQueues;

        private Long numberOfAssociatedUsers;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfile model) {
            instanceId(model.instanceId);
            name(model.name);
            routingProfileArn(model.routingProfileArn);
            routingProfileId(model.routingProfileId);
            description(model.description);
            mediaConcurrencies(model.mediaConcurrencies);
            defaultOutboundQueueId(model.defaultOutboundQueueId);
            tags(model.tags);
            numberOfAssociatedQueues(model.numberOfAssociatedQueues);
            numberOfAssociatedUsers(model.numberOfAssociatedUsers);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingProfileArn() {
            return routingProfileArn;
        }

        public final void setRoutingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
        }

        @Override
        public final Builder routingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<MediaConcurrency.Builder> getMediaConcurrencies() {
            List<MediaConcurrency.Builder> result = MediaConcurrenciesCopier.copyToBuilder(this.mediaConcurrencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency... mediaConcurrencies) {
            mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder>... mediaConcurrencies) {
            mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> MediaConcurrency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultOutboundQueueId() {
            return defaultOutboundQueueId;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Long getNumberOfAssociatedQueues() {
            return numberOfAssociatedQueues;
        }

        public final void setNumberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
        }

        @Override
        public final Builder numberOfAssociatedQueues(Long numberOfAssociatedQueues) {
            this.numberOfAssociatedQueues = numberOfAssociatedQueues;
            return this;
        }

        public final Long getNumberOfAssociatedUsers() {
            return numberOfAssociatedUsers;
        }

        public final void setNumberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
        }

        @Override
        public final Builder numberOfAssociatedUsers(Long numberOfAssociatedUsers) {
            this.numberOfAssociatedUsers = numberOfAssociatedUsers;
            return this;
        }

        @Override
        public RoutingProfile build() {
            return new RoutingProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
