/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewRequest;
import software.amazon.awssdk.services.databrew.model.FormatOptions;
import software.amazon.awssdk.services.databrew.model.Input;
import software.amazon.awssdk.services.databrew.model.InputFormat;
import software.amazon.awssdk.services.databrew.model.PathOptions;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDatasetRequest
extends DataBrewRequest
implements ToCopyableBuilder<Builder, CreateDatasetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateDatasetRequest.getter(CreateDatasetRequest::name)).setter(CreateDatasetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(CreateDatasetRequest.getter(CreateDatasetRequest::formatAsString)).setter(CreateDatasetRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatOptions").getter(CreateDatasetRequest.getter(CreateDatasetRequest::formatOptions)).setter(CreateDatasetRequest.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()}).build();
    private static final SdkField<Input> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Input").getter(CreateDatasetRequest.getter(CreateDatasetRequest::input)).setter(CreateDatasetRequest.setter(Builder::input)).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Input").build()}).build();
    private static final SdkField<PathOptions> PATH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PathOptions").getter(CreateDatasetRequest.getter(CreateDatasetRequest::pathOptions)).setter(CreateDatasetRequest.setter(Builder::pathOptions)).constructor(PathOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathOptions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateDatasetRequest.getter(CreateDatasetRequest::tags)).setter(CreateDatasetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD, FORMAT_OPTIONS_FIELD, INPUT_FIELD, PATH_OPTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDatasetRequest.memberNameToFieldInitializer();
    private final String name;
    private final String format;
    private final FormatOptions formatOptions;
    private final Input input;
    private final PathOptions pathOptions;
    private final Map<String, String> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.format = builder.format;
        this.formatOptions = builder.formatOptions;
        this.input = builder.input;
        this.pathOptions = builder.pathOptions;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final InputFormat format() {
        return InputFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final Input input() {
        return this.input;
    }

    public final PathOptions pathOptions() {
        return this.pathOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.pathOptions(), other.pathOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDatasetRequest").add("Name", (Object)this.name()).add("Format", (Object)this.formatAsString()).add("FormatOptions", (Object)this.formatOptions()).add("Input", (Object)this.input()).add("PathOptions", (Object)this.pathOptions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "FormatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "PathOptions": {
                return Optional.ofNullable(clazz.cast(this.pathOptions()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("FormatOptions", FORMAT_OPTIONS_FIELD);
        map.put("Input", INPUT_FIELD);
        map.put("PathOptions", PATH_OPTIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewRequest.BuilderImpl
    implements Builder {
        private String name;
        private String format;
        private FormatOptions formatOptions;
        private Input input;
        private PathOptions pathOptions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            this.name(model.name);
            this.format(model.format);
            this.formatOptions(model.formatOptions);
            this.input(model.input);
            this.pathOptions(model.pathOptions);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(InputFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final Input.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(Input.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(Input input) {
            this.input = input;
            return this;
        }

        public final PathOptions.Builder getPathOptions() {
            return this.pathOptions != null ? this.pathOptions.toBuilder() : null;
        }

        public final void setPathOptions(PathOptions.BuilderImpl pathOptions) {
            this.pathOptions = pathOptions != null ? pathOptions.build() : null;
        }

        @Override
        public final Builder pathOptions(PathOptions pathOptions) {
            this.pathOptions = pathOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDatasetRequest> {
        public Builder name(String var1);

        public Builder format(String var1);

        public Builder format(InputFormat var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder input(Input var1);

        default public Builder input(Consumer<Input.Builder> input) {
            return this.input((Input)((Input.Builder)Input.builder().applyMutation(input)).build());
        }

        public Builder pathOptions(PathOptions var1);

        default public Builder pathOptions(Consumer<PathOptions.Builder> pathOptions) {
            return this.pathOptions((PathOptions)((PathOptions.Builder)PathOptions.builder().applyMutation(pathOptions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

