/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databrew.model.ColumnNameListCopier;
import software.amazon.awssdk.services.databrew.model.CompressionFormat;
import software.amazon.awssdk.services.databrew.model.OutputFormat;
import software.amazon.awssdk.services.databrew.model.OutputFormatOptions;
import software.amazon.awssdk.services.databrew.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Output
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Output> {
    private static final SdkField<String> COMPRESSION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompressionFormat").getter(Output.getter(Output::compressionFormatAsString)).setter(Output.setter(Builder::compressionFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompressionFormat").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(Output.getter(Output::formatAsString)).setter(Output.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<List<String>> PARTITION_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionColumns").getter(Output.getter(Output::partitionColumns)).setter(Output.setter(Builder::partitionColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Location").getter(Output.getter(Output::location)).setter(Output.setter(Builder::location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final SdkField<Boolean> OVERWRITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Overwrite").getter(Output.getter(Output::overwrite)).setter(Output.setter(Builder::overwrite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overwrite").build()}).build();
    private static final SdkField<OutputFormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FormatOptions").getter(Output.getter(Output::formatOptions)).setter(Output.setter(Builder::formatOptions)).constructor(OutputFormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatOptions").build()}).build();
    private static final SdkField<Integer> MAX_OUTPUT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxOutputFiles").getter(Output.getter(Output::maxOutputFiles)).setter(Output.setter(Builder::maxOutputFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxOutputFiles").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPRESSION_FORMAT_FIELD, FORMAT_FIELD, PARTITION_COLUMNS_FIELD, LOCATION_FIELD, OVERWRITE_FIELD, FORMAT_OPTIONS_FIELD, MAX_OUTPUT_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Output.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String compressionFormat;
    private final String format;
    private final List<String> partitionColumns;
    private final S3Location location;
    private final Boolean overwrite;
    private final OutputFormatOptions formatOptions;
    private final Integer maxOutputFiles;

    private Output(BuilderImpl builder) {
        this.compressionFormat = builder.compressionFormat;
        this.format = builder.format;
        this.partitionColumns = builder.partitionColumns;
        this.location = builder.location;
        this.overwrite = builder.overwrite;
        this.formatOptions = builder.formatOptions;
        this.maxOutputFiles = builder.maxOutputFiles;
    }

    public final CompressionFormat compressionFormat() {
        return CompressionFormat.fromValue(this.compressionFormat);
    }

    public final String compressionFormatAsString() {
        return this.compressionFormat;
    }

    public final OutputFormat format() {
        return OutputFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final boolean hasPartitionColumns() {
        return this.partitionColumns != null && !(this.partitionColumns instanceof SdkAutoConstructList);
    }

    public final List<String> partitionColumns() {
        return this.partitionColumns;
    }

    public final S3Location location() {
        return this.location;
    }

    public final Boolean overwrite() {
        return this.overwrite;
    }

    public final OutputFormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final Integer maxOutputFiles() {
        return this.maxOutputFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compressionFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionColumns() ? this.partitionColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwrite());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxOutputFiles());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.compressionFormatAsString(), other.compressionFormatAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && this.hasPartitionColumns() == other.hasPartitionColumns() && Objects.equals(this.partitionColumns(), other.partitionColumns()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.overwrite(), other.overwrite()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.maxOutputFiles(), other.maxOutputFiles());
    }

    public final String toString() {
        return ToString.builder((String)"Output").add("CompressionFormat", (Object)this.compressionFormatAsString()).add("Format", (Object)this.formatAsString()).add("PartitionColumns", this.hasPartitionColumns() ? this.partitionColumns() : null).add("Location", (Object)this.location()).add("Overwrite", (Object)this.overwrite()).add("FormatOptions", (Object)this.formatOptions()).add("MaxOutputFiles", (Object)this.maxOutputFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompressionFormat": {
                return Optional.ofNullable(clazz.cast(this.compressionFormatAsString()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "PartitionColumns": {
                return Optional.ofNullable(clazz.cast(this.partitionColumns()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Overwrite": {
                return Optional.ofNullable(clazz.cast(this.overwrite()));
            }
            case "FormatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "MaxOutputFiles": {
                return Optional.ofNullable(clazz.cast(this.maxOutputFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompressionFormat", COMPRESSION_FORMAT_FIELD);
        map.put("Format", FORMAT_FIELD);
        map.put("PartitionColumns", PARTITION_COLUMNS_FIELD);
        map.put("Location", LOCATION_FIELD);
        map.put("Overwrite", OVERWRITE_FIELD);
        map.put("FormatOptions", FORMAT_OPTIONS_FIELD);
        map.put("MaxOutputFiles", MAX_OUTPUT_FILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Output, T> g) {
        return obj -> g.apply((Output)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String compressionFormat;
        private String format;
        private List<String> partitionColumns = DefaultSdkAutoConstructList.getInstance();
        private S3Location location;
        private Boolean overwrite;
        private OutputFormatOptions formatOptions;
        private Integer maxOutputFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.compressionFormat(model.compressionFormat);
            this.format(model.format);
            this.partitionColumns(model.partitionColumns);
            this.location(model.location);
            this.overwrite(model.overwrite);
            this.formatOptions(model.formatOptions);
            this.maxOutputFiles(model.maxOutputFiles);
        }

        public final String getCompressionFormat() {
            return this.compressionFormat;
        }

        public final void setCompressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
        }

        @Override
        public final Builder compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        @Override
        public final Builder compressionFormat(CompressionFormat compressionFormat) {
            this.compressionFormat(compressionFormat == null ? null : compressionFormat.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(OutputFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Collection<String> getPartitionColumns() {
            if (this.partitionColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionColumns;
        }

        public final void setPartitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = ColumnNameListCopier.copy(partitionColumns);
        }

        @Override
        public final Builder partitionColumns(Collection<String> partitionColumns) {
            this.partitionColumns = ColumnNameListCopier.copy(partitionColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionColumns(String ... partitionColumns) {
            this.partitionColumns(Arrays.asList(partitionColumns));
            return this;
        }

        public final S3Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(S3Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(S3Location location) {
            this.location = location;
            return this;
        }

        public final Boolean getOverwrite() {
            return this.overwrite;
        }

        public final void setOverwrite(Boolean overwrite) {
            this.overwrite = overwrite;
        }

        @Override
        public final Builder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public final OutputFormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(OutputFormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(OutputFormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final Integer getMaxOutputFiles() {
            return this.maxOutputFiles;
        }

        public final void setMaxOutputFiles(Integer maxOutputFiles) {
            this.maxOutputFiles = maxOutputFiles;
        }

        @Override
        public final Builder maxOutputFiles(Integer maxOutputFiles) {
            this.maxOutputFiles = maxOutputFiles;
            return this;
        }

        public Output build() {
            return new Output(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Output> {
        public Builder compressionFormat(String var1);

        public Builder compressionFormat(CompressionFormat var1);

        public Builder format(String var1);

        public Builder format(OutputFormat var1);

        public Builder partitionColumns(Collection<String> var1);

        public Builder partitionColumns(String ... var1);

        public Builder location(S3Location var1);

        default public Builder location(Consumer<S3Location.Builder> location) {
            return this.location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(location)).build());
        }

        public Builder overwrite(Boolean var1);

        public Builder formatOptions(OutputFormatOptions var1);

        default public Builder formatOptions(Consumer<OutputFormatOptions.Builder> formatOptions) {
            return this.formatOptions((OutputFormatOptions)((OutputFormatOptions.Builder)OutputFormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder maxOutputFiles(Integer var1);
    }
}

