/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OperatorType {
    EQ("EQ"),
    REF_EQ("REF_EQ"),
    LE("LE"),
    GE("GE"),
    BETWEEN("BETWEEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OperatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OperatorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatorType> knownValues() {
        return Stream.of(OperatorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

