/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TaskStatus {
    AVAILABLE("AVAILABLE"),
    CREATING("CREATING"),
    RUNNING("RUNNING"),
    UNAVAILABLE("UNAVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TaskStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TaskStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TaskStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TaskStatus> knownValues() {
        return Stream.of(TaskStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

