/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest;
import software.amazon.awssdk.services.datasync.model.ListTaskExecutionsResponse;

public class ListTaskExecutionsPublisher
implements SdkPublisher<ListTaskExecutionsResponse> {
    private final DataSyncAsyncClient client;
    private final ListTaskExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskExecutionsPublisher(DataSyncAsyncClient client, ListTaskExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskExecutionsPublisher(DataSyncAsyncClient client, ListTaskExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListTaskExecutionsPublisher resume(ListTaskExecutionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTaskExecutionsPublisher(this.client, (ListTaskExecutionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTaskExecutionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTaskExecutionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTaskExecutionsResponseFetcher
    implements AsyncPageFetcher<ListTaskExecutionsResponse> {
        private ListTaskExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskExecutionsResponse> nextPage(ListTaskExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListTaskExecutionsPublisher.this.client.listTaskExecutions(ListTaskExecutionsPublisher.this.firstRequest);
            }
            return ListTaskExecutionsPublisher.this.client.listTaskExecutions((ListTaskExecutionsRequest)((Object)ListTaskExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

