/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.TaskExecutionListCopier;
import software.amazon.awssdk.services.datasync.model.TaskExecutionListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskExecutionsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, ListTaskExecutionsResponse> {
    private static final SdkField<List<TaskExecutionListEntry>> TASK_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskExecutions").getter(ListTaskExecutionsResponse.getter(ListTaskExecutionsResponse::taskExecutions)).setter(ListTaskExecutionsResponse.setter(Builder::taskExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskExecutionListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTaskExecutionsResponse.getter(ListTaskExecutionsResponse::nextToken)).setter(ListTaskExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<TaskExecutionListEntry> taskExecutions;
    private final String nextToken;

    private ListTaskExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.taskExecutions = builder.taskExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTaskExecutions() {
        return this.taskExecutions != null && !(this.taskExecutions instanceof SdkAutoConstructList);
    }

    public final List<TaskExecutionListEntry> taskExecutions() {
        return this.taskExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskExecutions() ? this.taskExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskExecutionsResponse)) {
            return false;
        }
        ListTaskExecutionsResponse other = (ListTaskExecutionsResponse)((Object)obj);
        return this.hasTaskExecutions() == other.hasTaskExecutions() && Objects.equals(this.taskExecutions(), other.taskExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTaskExecutionsResponse").add("TaskExecutions", this.hasTaskExecutions() ? this.taskExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskExecutions": {
                return Optional.ofNullable(clazz.cast(this.taskExecutions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskExecutionsResponse, T> g) {
        return obj -> g.apply((ListTaskExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private List<TaskExecutionListEntry> taskExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskExecutionsResponse model) {
            super(model);
            this.taskExecutions(model.taskExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<TaskExecutionListEntry.Builder> getTaskExecutions() {
            List<TaskExecutionListEntry.Builder> result = TaskExecutionListCopier.copyToBuilder(this.taskExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskExecutions(Collection<TaskExecutionListEntry.BuilderImpl> taskExecutions) {
            this.taskExecutions = TaskExecutionListCopier.copyFromBuilder(taskExecutions);
        }

        @Override
        @Transient
        public final Builder taskExecutions(Collection<TaskExecutionListEntry> taskExecutions) {
            this.taskExecutions = TaskExecutionListCopier.copy(taskExecutions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taskExecutions(TaskExecutionListEntry ... taskExecutions) {
            this.taskExecutions(Arrays.asList(taskExecutions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder taskExecutions(Consumer<TaskExecutionListEntry.Builder> ... taskExecutions) {
            this.taskExecutions(Stream.of(taskExecutions).map(c -> (TaskExecutionListEntry)((TaskExecutionListEntry.Builder)TaskExecutionListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTaskExecutionsResponse build() {
            return new ListTaskExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskExecutionsResponse> {
        public Builder taskExecutions(Collection<TaskExecutionListEntry> var1);

        public Builder taskExecutions(TaskExecutionListEntry ... var1);

        public Builder taskExecutions(Consumer<TaskExecutionListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

