/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocationFsxOntapResponse extends DataSyncResponse implements
        ToCopyableBuilder<DescribeLocationFsxOntapResponse.Builder, DescribeLocationFsxOntapResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeLocationFsxOntapResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationArn").getter(getter(DescribeLocationFsxOntapResponse::locationArn))
            .setter(setter(Builder::locationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()).build();

    private static final SdkField<String> LOCATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocationUri").getter(getter(DescribeLocationFsxOntapResponse::locationUri))
            .setter(setter(Builder::locationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationUri").build()).build();

    private static final SdkField<FsxProtocol> PROTOCOL_FIELD = SdkField.<FsxProtocol> builder(MarshallingType.SDK_POJO)
            .memberName("Protocol").getter(getter(DescribeLocationFsxOntapResponse::protocol)).setter(setter(Builder::protocol))
            .constructor(FsxProtocol::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupArns")
            .getter(getter(DescribeLocationFsxOntapResponse::securityGroupArns))
            .setter(setter(Builder::securityGroupArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVirtualMachineArn").getter(getter(DescribeLocationFsxOntapResponse::storageVirtualMachineArn))
            .setter(setter(Builder::storageVirtualMachineArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineArn").build())
            .build();

    private static final SdkField<String> FSX_FILESYSTEM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FsxFilesystemArn").getter(getter(DescribeLocationFsxOntapResponse::fsxFilesystemArn))
            .setter(setter(Builder::fsxFilesystemArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FsxFilesystemArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            LOCATION_ARN_FIELD, LOCATION_URI_FIELD, PROTOCOL_FIELD, SECURITY_GROUP_ARNS_FIELD, STORAGE_VIRTUAL_MACHINE_ARN_FIELD,
            FSX_FILESYSTEM_ARN_FIELD));

    private final Instant creationTime;

    private final String locationArn;

    private final String locationUri;

    private final FsxProtocol protocol;

    private final List<String> securityGroupArns;

    private final String storageVirtualMachineArn;

    private final String fsxFilesystemArn;

    private DescribeLocationFsxOntapResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.locationArn = builder.locationArn;
        this.locationUri = builder.locationUri;
        this.protocol = builder.protocol;
        this.securityGroupArns = builder.securityGroupArns;
        this.storageVirtualMachineArn = builder.storageVirtualMachineArn;
        this.fsxFilesystemArn = builder.fsxFilesystemArn;
    }

    /**
     * <p>
     * The time that the location was created.
     * </p>
     * 
     * @return The time that the location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ARN of the FSx for ONTAP file system location.
     * </p>
     * 
     * @return The ARN of the FSx for ONTAP file system location.
     */
    public final String locationArn() {
        return locationArn;
    }

    /**
     * <p>
     * The uniform resource identifier (URI) of the FSx for ONTAP file system location.
     * </p>
     * 
     * @return The uniform resource identifier (URI) of the FSx for ONTAP file system location.
     */
    public final String locationUri() {
        return locationUri;
    }

    /**
     * Returns the value of the Protocol property for this object.
     * 
     * @return The value of the Protocol property for this object.
     */
    public final FsxProtocol protocol() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupArns() {
        return securityGroupArns != null && !(securityGroupArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups that DataSync uses to access your FSx for ONTAP file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupArns} method.
     * </p>
     * 
     * @return The security groups that DataSync uses to access your FSx for ONTAP file system.
     */
    public final List<String> securityGroupArns() {
        return securityGroupArns;
    }

    /**
     * <p>
     * The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system where you're copying data to or
     * from.
     * </p>
     * 
     * @return The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system where you're copying data
     *         to or from.
     */
    public final String storageVirtualMachineArn() {
        return storageVirtualMachineArn;
    }

    /**
     * <p>
     * The ARN of the FSx for ONTAP file system.
     * </p>
     * 
     * @return The ARN of the FSx for ONTAP file system.
     */
    public final String fsxFilesystemArn() {
        return fsxFilesystemArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(locationUri());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupArns() ? securityGroupArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageVirtualMachineArn());
        hashCode = 31 * hashCode + Objects.hashCode(fsxFilesystemArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocationFsxOntapResponse)) {
            return false;
        }
        DescribeLocationFsxOntapResponse other = (DescribeLocationFsxOntapResponse) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(locationArn(), other.locationArn())
                && Objects.equals(locationUri(), other.locationUri()) && Objects.equals(protocol(), other.protocol())
                && hasSecurityGroupArns() == other.hasSecurityGroupArns()
                && Objects.equals(securityGroupArns(), other.securityGroupArns())
                && Objects.equals(storageVirtualMachineArn(), other.storageVirtualMachineArn())
                && Objects.equals(fsxFilesystemArn(), other.fsxFilesystemArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLocationFsxOntapResponse").add("CreationTime", creationTime())
                .add("LocationArn", locationArn()).add("LocationUri", locationUri()).add("Protocol", protocol())
                .add("SecurityGroupArns", hasSecurityGroupArns() ? securityGroupArns() : null)
                .add("StorageVirtualMachineArn", storageVirtualMachineArn()).add("FsxFilesystemArn", fsxFilesystemArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LocationArn":
            return Optional.ofNullable(clazz.cast(locationArn()));
        case "LocationUri":
            return Optional.ofNullable(clazz.cast(locationUri()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "SecurityGroupArns":
            return Optional.ofNullable(clazz.cast(securityGroupArns()));
        case "StorageVirtualMachineArn":
            return Optional.ofNullable(clazz.cast(storageVirtualMachineArn()));
        case "FsxFilesystemArn":
            return Optional.ofNullable(clazz.cast(fsxFilesystemArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocationFsxOntapResponse, T> g) {
        return obj -> g.apply((DescribeLocationFsxOntapResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocationFsxOntapResponse> {
        /**
         * <p>
         * The time that the location was created.
         * </p>
         * 
         * @param creationTime
         *        The time that the location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ARN of the FSx for ONTAP file system location.
         * </p>
         * 
         * @param locationArn
         *        The ARN of the FSx for ONTAP file system location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationArn(String locationArn);

        /**
         * <p>
         * The uniform resource identifier (URI) of the FSx for ONTAP file system location.
         * </p>
         * 
         * @param locationUri
         *        The uniform resource identifier (URI) of the FSx for ONTAP file system location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationUri(String locationUri);

        /**
         * Sets the value of the Protocol property for this object.
         *
         * @param protocol
         *        The new value for the Protocol property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(FsxProtocol protocol);

        /**
         * Sets the value of the Protocol property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FsxProtocol.Builder} avoiding the need to
         * create one manually via {@link FsxProtocol#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxProtocol.Builder#build()} is called immediately and its result
         * is passed to {@link #protocol(FsxProtocol)}.
         * 
         * @param protocol
         *        a consumer that will call methods on {@link FsxProtocol.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #protocol(FsxProtocol)
         */
        default Builder protocol(Consumer<FsxProtocol.Builder> protocol) {
            return protocol(FsxProtocol.builder().applyMutation(protocol).build());
        }

        /**
         * <p>
         * The security groups that DataSync uses to access your FSx for ONTAP file system.
         * </p>
         * 
         * @param securityGroupArns
         *        The security groups that DataSync uses to access your FSx for ONTAP file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(Collection<String> securityGroupArns);

        /**
         * <p>
         * The security groups that DataSync uses to access your FSx for ONTAP file system.
         * </p>
         * 
         * @param securityGroupArns
         *        The security groups that DataSync uses to access your FSx for ONTAP file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupArns(String... securityGroupArns);

        /**
         * <p>
         * The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system where you're copying data to
         * or from.
         * </p>
         * 
         * @param storageVirtualMachineArn
         *        The ARN of the storage virtual machine (SVM) on your FSx for ONTAP file system where you're copying
         *        data to or from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageVirtualMachineArn(String storageVirtualMachineArn);

        /**
         * <p>
         * The ARN of the FSx for ONTAP file system.
         * </p>
         * 
         * @param fsxFilesystemArn
         *        The ARN of the FSx for ONTAP file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsxFilesystemArn(String fsxFilesystemArn);
    }

    static final class BuilderImpl extends DataSyncResponse.BuilderImpl implements Builder {
        private Instant creationTime;

        private String locationArn;

        private String locationUri;

        private FsxProtocol protocol;

        private List<String> securityGroupArns = DefaultSdkAutoConstructList.getInstance();

        private String storageVirtualMachineArn;

        private String fsxFilesystemArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocationFsxOntapResponse model) {
            super(model);
            creationTime(model.creationTime);
            locationArn(model.locationArn);
            locationUri(model.locationUri);
            protocol(model.protocol);
            securityGroupArns(model.securityGroupArns);
            storageVirtualMachineArn(model.storageVirtualMachineArn);
            fsxFilesystemArn(model.fsxFilesystemArn);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLocationArn() {
            return locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getLocationUri() {
            return locationUri;
        }

        public final void setLocationUri(String locationUri) {
            this.locationUri = locationUri;
        }

        @Override
        public final Builder locationUri(String locationUri) {
            this.locationUri = locationUri;
            return this;
        }

        public final FsxProtocol.Builder getProtocol() {
            return protocol != null ? protocol.toBuilder() : null;
        }

        public final void setProtocol(FsxProtocol.BuilderImpl protocol) {
            this.protocol = protocol != null ? protocol.build() : null;
        }

        @Override
        public final Builder protocol(FsxProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Collection<String> getSecurityGroupArns() {
            if (securityGroupArns instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupArns;
        }

        public final void setSecurityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
        }

        @Override
        public final Builder securityGroupArns(Collection<String> securityGroupArns) {
            this.securityGroupArns = Ec2SecurityGroupArnListCopier.copy(securityGroupArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupArns(String... securityGroupArns) {
            securityGroupArns(Arrays.asList(securityGroupArns));
            return this;
        }

        public final String getStorageVirtualMachineArn() {
            return storageVirtualMachineArn;
        }

        public final void setStorageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
        }

        @Override
        public final Builder storageVirtualMachineArn(String storageVirtualMachineArn) {
            this.storageVirtualMachineArn = storageVirtualMachineArn;
            return this;
        }

        public final String getFsxFilesystemArn() {
            return fsxFilesystemArn;
        }

        public final void setFsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
        }

        @Override
        public final Builder fsxFilesystemArn(String fsxFilesystemArn) {
            this.fsxFilesystemArn = fsxFilesystemArn;
            return this;
        }

        @Override
        public DescribeLocationFsxOntapResponse build() {
            return new DescribeLocationFsxOntapResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
