/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.DataSyncResponse;
import software.amazon.awssdk.services.datasync.model.StorageSystemListCopier;
import software.amazon.awssdk.services.datasync.model.StorageSystemListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStorageSystemsResponse
extends DataSyncResponse
implements ToCopyableBuilder<Builder, ListStorageSystemsResponse> {
    private static final SdkField<List<StorageSystemListEntry>> STORAGE_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StorageSystems").getter(ListStorageSystemsResponse.getter(ListStorageSystemsResponse::storageSystems)).setter(ListStorageSystemsResponse.setter(Builder::storageSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageSystemListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStorageSystemsResponse.getter(ListStorageSystemsResponse::nextToken)).setter(ListStorageSystemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_SYSTEMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StorageSystemListEntry> storageSystems;
    private final String nextToken;

    private ListStorageSystemsResponse(BuilderImpl builder) {
        super(builder);
        this.storageSystems = builder.storageSystems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStorageSystems() {
        return this.storageSystems != null && !(this.storageSystems instanceof SdkAutoConstructList);
    }

    public final List<StorageSystemListEntry> storageSystems() {
        return this.storageSystems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorageSystems() ? this.storageSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStorageSystemsResponse)) {
            return false;
        }
        ListStorageSystemsResponse other = (ListStorageSystemsResponse)((Object)obj);
        return this.hasStorageSystems() == other.hasStorageSystems() && Objects.equals(this.storageSystems(), other.storageSystems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStorageSystemsResponse").add("StorageSystems", this.hasStorageSystems() ? this.storageSystems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageSystems": {
                return Optional.ofNullable(clazz.cast(this.storageSystems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStorageSystemsResponse, T> g) {
        return obj -> g.apply((ListStorageSystemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncResponse.BuilderImpl
    implements Builder {
        private List<StorageSystemListEntry> storageSystems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStorageSystemsResponse model) {
            super(model);
            this.storageSystems(model.storageSystems);
            this.nextToken(model.nextToken);
        }

        public final List<StorageSystemListEntry.Builder> getStorageSystems() {
            List<StorageSystemListEntry.Builder> result = StorageSystemListCopier.copyToBuilder(this.storageSystems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageSystems(Collection<StorageSystemListEntry.BuilderImpl> storageSystems) {
            this.storageSystems = StorageSystemListCopier.copyFromBuilder(storageSystems);
        }

        @Override
        public final Builder storageSystems(Collection<StorageSystemListEntry> storageSystems) {
            this.storageSystems = StorageSystemListCopier.copy(storageSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSystems(StorageSystemListEntry ... storageSystems) {
            this.storageSystems(Arrays.asList(storageSystems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageSystems(Consumer<StorageSystemListEntry.Builder> ... storageSystems) {
            this.storageSystems(Stream.of(storageSystems).map(c -> (StorageSystemListEntry)((StorageSystemListEntry.Builder)StorageSystemListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStorageSystemsResponse build() {
            return new ListStorageSystemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStorageSystemsResponse> {
        public Builder storageSystems(Collection<StorageSystemListEntry> var1);

        public Builder storageSystems(StorageSystemListEntry ... var1);

        public Builder storageSystems(Consumer<StorageSystemListEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

