/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.concurrent.atomic.AtomicBoolean;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.BooleanAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class AtomicBooleanAttributeConverter
implements AttributeConverter<AtomicBoolean> {
    private static final BooleanAttributeConverter BOOLEAN_CONVERTER = BooleanAttributeConverter.create();

    private AtomicBooleanAttributeConverter() {
    }

    @Override
    public EnhancedType<AtomicBoolean> type() {
        return EnhancedType.of(AtomicBoolean.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.BOOL;
    }

    public static AtomicBooleanAttributeConverter create() {
        return new AtomicBooleanAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(AtomicBoolean input) {
        return (AttributeValue)AttributeValue.builder().bool(Boolean.valueOf(input.get())).build();
    }

    @Override
    public AtomicBoolean transformTo(AttributeValue input) {
        return new AtomicBoolean(BOOLEAN_CONVERTER.transformTo(input));
    }
}

