/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.CommonOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.DefaultOperationContext;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface TableOperation<ItemT, RequestT, ResponseT, ResultT>
extends CommonOperation<ItemT, RequestT, ResponseT, ResultT> {
    default public ResultT executeOnPrimaryIndex(TableSchema<ItemT> tableSchema, String tableName, DynamoDbEnhancedClientExtension extension, DynamoDbClient dynamoDbClient) {
        DefaultOperationContext context = DefaultOperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.execute(tableSchema, context, extension, dynamoDbClient);
    }

    default public CompletableFuture<ResultT> executeOnPrimaryIndexAsync(TableSchema<ItemT> tableSchema, String tableName, DynamoDbEnhancedClientExtension extension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        DefaultOperationContext context = DefaultOperationContext.create(tableName, TableMetadata.primaryIndexName());
        return this.executeAsync(tableSchema, context, extension, dynamoDbAsyncClient);
    }
}

