/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingSettingsUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaAutoScalingUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaAutoScalingUpdate> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ReplicaAutoScalingUpdate.getter(ReplicaAutoScalingUpdate::regionName)).setter(ReplicaAutoScalingUpdate.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexAutoScalingUpdate>> REPLICA_GLOBAL_SECONDARY_INDEX_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaGlobalSecondaryIndexUpdates").getter(ReplicaAutoScalingUpdate.getter(ReplicaAutoScalingUpdate::replicaGlobalSecondaryIndexUpdates)).setter(ReplicaAutoScalingUpdate.setter(Builder::replicaGlobalSecondaryIndexUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaGlobalSecondaryIndexUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexAutoScalingUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoScalingSettingsUpdate> REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaProvisionedReadCapacityAutoScalingUpdate").getter(ReplicaAutoScalingUpdate.getter(ReplicaAutoScalingUpdate::replicaProvisionedReadCapacityAutoScalingUpdate)).setter(ReplicaAutoScalingUpdate.setter(Builder::replicaProvisionedReadCapacityAutoScalingUpdate)).constructor(AutoScalingSettingsUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaProvisionedReadCapacityAutoScalingUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REPLICA_GLOBAL_SECONDARY_INDEX_UPDATES_FIELD, REPLICA_PROVISIONED_READ_CAPACITY_AUTO_SCALING_UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates;
    private final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate;

    private ReplicaAutoScalingUpdate(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaGlobalSecondaryIndexUpdates = builder.replicaGlobalSecondaryIndexUpdates;
        this.replicaProvisionedReadCapacityAutoScalingUpdate = builder.replicaProvisionedReadCapacityAutoScalingUpdate;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final boolean hasReplicaGlobalSecondaryIndexUpdates() {
        return this.replicaGlobalSecondaryIndexUpdates != null && !(this.replicaGlobalSecondaryIndexUpdates instanceof SdkAutoConstructList);
    }

    public final List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates() {
        return this.replicaGlobalSecondaryIndexUpdates;
    }

    public final AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate() {
        return this.replicaProvisionedReadCapacityAutoScalingUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicaGlobalSecondaryIndexUpdates() ? this.replicaGlobalSecondaryIndexUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaProvisionedReadCapacityAutoScalingUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaAutoScalingUpdate)) {
            return false;
        }
        ReplicaAutoScalingUpdate other = (ReplicaAutoScalingUpdate)obj;
        return Objects.equals(this.regionName(), other.regionName()) && this.hasReplicaGlobalSecondaryIndexUpdates() == other.hasReplicaGlobalSecondaryIndexUpdates() && Objects.equals(this.replicaGlobalSecondaryIndexUpdates(), other.replicaGlobalSecondaryIndexUpdates()) && Objects.equals(this.replicaProvisionedReadCapacityAutoScalingUpdate(), other.replicaProvisionedReadCapacityAutoScalingUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaAutoScalingUpdate").add("RegionName", (Object)this.regionName()).add("ReplicaGlobalSecondaryIndexUpdates", this.hasReplicaGlobalSecondaryIndexUpdates() ? this.replicaGlobalSecondaryIndexUpdates() : null).add("ReplicaProvisionedReadCapacityAutoScalingUpdate", (Object)this.replicaProvisionedReadCapacityAutoScalingUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaGlobalSecondaryIndexUpdates": {
                return Optional.ofNullable(clazz.cast(this.replicaGlobalSecondaryIndexUpdates()));
            }
            case "ReplicaProvisionedReadCapacityAutoScalingUpdate": {
                return Optional.ofNullable(clazz.cast(this.replicaProvisionedReadCapacityAutoScalingUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicaAutoScalingUpdate, T> g) {
        return obj -> g.apply((ReplicaAutoScalingUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private List<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates = DefaultSdkAutoConstructList.getInstance();
        private AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaAutoScalingUpdate model) {
            this.regionName(model.regionName);
            this.replicaGlobalSecondaryIndexUpdates(model.replicaGlobalSecondaryIndexUpdates);
            this.replicaProvisionedReadCapacityAutoScalingUpdate(model.replicaProvisionedReadCapacityAutoScalingUpdate);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder> getReplicaGlobalSecondaryIndexUpdates() {
            if (this.replicaGlobalSecondaryIndexUpdates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicaGlobalSecondaryIndexUpdates != null ? (Collection)this.replicaGlobalSecondaryIndexUpdates.stream().map(ReplicaGlobalSecondaryIndexAutoScalingUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaGlobalSecondaryIndexUpdates(Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate> replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates = ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier.copy(replicaGlobalSecondaryIndexUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexUpdates(ReplicaGlobalSecondaryIndexAutoScalingUpdate ... replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates(Arrays.asList(replicaGlobalSecondaryIndexUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaGlobalSecondaryIndexUpdates(Consumer<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder> ... replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates(Stream.of(replicaGlobalSecondaryIndexUpdates).map(c -> (ReplicaGlobalSecondaryIndexAutoScalingUpdate)((ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder)ReplicaGlobalSecondaryIndexAutoScalingUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaGlobalSecondaryIndexUpdates(Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate.BuilderImpl> replicaGlobalSecondaryIndexUpdates) {
            this.replicaGlobalSecondaryIndexUpdates = ReplicaGlobalSecondaryIndexAutoScalingUpdateListCopier.copyFromBuilder(replicaGlobalSecondaryIndexUpdates);
        }

        public final AutoScalingSettingsUpdate.Builder getReplicaProvisionedReadCapacityAutoScalingUpdate() {
            return this.replicaProvisionedReadCapacityAutoScalingUpdate != null ? this.replicaProvisionedReadCapacityAutoScalingUpdate.toBuilder() : null;
        }

        @Override
        public final Builder replicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate replicaProvisionedReadCapacityAutoScalingUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingUpdate = replicaProvisionedReadCapacityAutoScalingUpdate;
            return this;
        }

        public final void setReplicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate.BuilderImpl replicaProvisionedReadCapacityAutoScalingUpdate) {
            this.replicaProvisionedReadCapacityAutoScalingUpdate = replicaProvisionedReadCapacityAutoScalingUpdate != null ? replicaProvisionedReadCapacityAutoScalingUpdate.build() : null;
        }

        public ReplicaAutoScalingUpdate build() {
            return new ReplicaAutoScalingUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaAutoScalingUpdate> {
        public Builder regionName(String var1);

        public Builder replicaGlobalSecondaryIndexUpdates(Collection<ReplicaGlobalSecondaryIndexAutoScalingUpdate> var1);

        public Builder replicaGlobalSecondaryIndexUpdates(ReplicaGlobalSecondaryIndexAutoScalingUpdate ... var1);

        public Builder replicaGlobalSecondaryIndexUpdates(Consumer<ReplicaGlobalSecondaryIndexAutoScalingUpdate.Builder> ... var1);

        public Builder replicaProvisionedReadCapacityAutoScalingUpdate(AutoScalingSettingsUpdate var1);

        default public Builder replicaProvisionedReadCapacityAutoScalingUpdate(Consumer<AutoScalingSettingsUpdate.Builder> replicaProvisionedReadCapacityAutoScalingUpdate) {
            return this.replicaProvisionedReadCapacityAutoScalingUpdate((AutoScalingSettingsUpdate)((AutoScalingSettingsUpdate.Builder)AutoScalingSettingsUpdate.builder().applyMutation(replicaProvisionedReadCapacityAutoScalingUpdate)).build());
        }
    }
}

