/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum S3SseAlgorithm {
    AES256("AES256"),
    KMS("KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private S3SseAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3SseAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(S3SseAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3SseAlgorithm> knownValues() {
        return Stream.of(S3SseAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

