/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.services.dynamodb.DefaultDynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DefaultDynamoDbBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;

@SdkInternalApi
final class DefaultDynamoDbAsyncClientBuilder
extends DefaultDynamoDbBaseClientBuilder<DynamoDbAsyncClientBuilder, DynamoDbAsyncClient>
implements DynamoDbAsyncClientBuilder {
    DefaultDynamoDbAsyncClientBuilder() {
    }

    @Override
    public DefaultDynamoDbAsyncClientBuilder endpointDiscoveryEnabled(boolean endpointDiscoveryEnabled) {
        this.endpointDiscoveryEnabled = endpointDiscoveryEnabled;
        return this;
    }

    @Override
    @Deprecated
    public DefaultDynamoDbAsyncClientBuilder enableEndpointDiscovery() {
        this.endpointDiscoveryEnabled = true;
        return this;
    }

    @Override
    public DefaultDynamoDbAsyncClientBuilder endpointProvider(DynamoDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DynamoDbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDynamoDbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        return new DefaultDynamoDbAsyncClient(clientConfiguration);
    }
}

