/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClientBuilder;

@SdkPublicApi
@ThreadSafe
public interface DynamoDbStreamsAsyncClient
extends SdkClient {
    public static final String SERVICE_NAME = "dynamodb";
    public static final String SERVICE_METADATA_ID = "streams.dynamodb";

    default public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<DescribeStreamResponse> describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) {
        return this.describeStream((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().applyMutation(describeStreamRequest)).build()));
    }

    default public CompletableFuture<GetRecordsResponse> getRecords(GetRecordsRequest getRecordsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetRecordsResponse> getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().applyMutation(getRecordsRequest)).build()));
    }

    default public CompletableFuture<GetShardIteratorResponse> getShardIterator(GetShardIteratorRequest getShardIteratorRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetShardIteratorResponse> getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().applyMutation(getShardIteratorRequest)).build()));
    }

    default public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListStreamsResponse> listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    default public CompletableFuture<ListStreamsResponse> listStreams() {
        return this.listStreams((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    public static DynamoDbStreamsAsyncClient create() {
        return (DynamoDbStreamsAsyncClient)DynamoDbStreamsAsyncClient.builder().build();
    }

    public static DynamoDbStreamsAsyncClientBuilder builder() {
        return new DefaultDynamoDbStreamsAsyncClientBuilder();
    }
}

