/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeStream</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamResponse extends DynamoDbStreamsResponse implements
        ToCopyableBuilder<DescribeStreamResponse.Builder, DescribeStreamResponse> {
    private static final SdkField<StreamDescription> STREAM_DESCRIPTION_FIELD = SdkField
            .<StreamDescription> builder(MarshallingType.SDK_POJO).memberName("StreamDescription")
            .getter(getter(DescribeStreamResponse::streamDescription)).setter(setter(Builder::streamDescription))
            .constructor(StreamDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final StreamDescription streamDescription;

    private DescribeStreamResponse(BuilderImpl builder) {
        super(builder);
        this.streamDescription = builder.streamDescription;
    }

    /**
     * <p>
     * A complete description of the stream, including its creation date and time, the DynamoDB table associated with
     * the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream records
     * within the shards.
     * </p>
     * 
     * @return A complete description of the stream, including its creation date and time, the DynamoDB table associated
     *         with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream
     *         records within the shards.
     */
    public final StreamDescription streamDescription() {
        return streamDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamResponse)) {
            return false;
        }
        DescribeStreamResponse other = (DescribeStreamResponse) obj;
        return Objects.equals(streamDescription(), other.streamDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamResponse").add("StreamDescription", streamDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamDescription":
            return Optional.ofNullable(clazz.cast(streamDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamDescription", STREAM_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamResponse, T> g) {
        return obj -> g.apply((DescribeStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbStreamsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamResponse> {
        /**
         * <p>
         * A complete description of the stream, including its creation date and time, the DynamoDB table associated
         * with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream
         * records within the shards.
         * </p>
         * 
         * @param streamDescription
         *        A complete description of the stream, including its creation date and time, the DynamoDB table
         *        associated with the stream, the shard IDs within the stream, and the beginning and ending sequence
         *        numbers of stream records within the shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescription(StreamDescription streamDescription);

        /**
         * <p>
         * A complete description of the stream, including its creation date and time, the DynamoDB table associated
         * with the stream, the shard IDs within the stream, and the beginning and ending sequence numbers of stream
         * records within the shards.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamDescription.Builder} avoiding the
         * need to create one manually via {@link StreamDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #streamDescription(StreamDescription)}.
         * 
         * @param streamDescription
         *        a consumer that will call methods on {@link StreamDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamDescription(StreamDescription)
         */
        default Builder streamDescription(Consumer<StreamDescription.Builder> streamDescription) {
            return streamDescription(StreamDescription.builder().applyMutation(streamDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbStreamsResponse.BuilderImpl implements Builder {
        private StreamDescription streamDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamResponse model) {
            super(model);
            streamDescription(model.streamDescription);
        }

        public final StreamDescription.Builder getStreamDescription() {
            return streamDescription != null ? streamDescription.toBuilder() : null;
        }

        public final void setStreamDescription(StreamDescription.BuilderImpl streamDescription) {
            this.streamDescription = streamDescription != null ? streamDescription.build() : null;
        }

        @Override
        public final Builder streamDescription(StreamDescription streamDescription) {
            this.streamDescription = streamDescription;
            return this;
        }

        @Override
        public DescribeStreamResponse build() {
            return new DescribeStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
