/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>ListTables</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ListTablesRequest.Builder, ListTablesRequest> {
    private static final SdkField<String> EXCLUSIVE_START_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartTableName").getter(getter(ListTablesRequest::exclusiveStartTableName))
            .setter(setter(Builder::exclusiveStartTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartTableName").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListTablesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXCLUSIVE_START_TABLE_NAME_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String exclusiveStartTableName;

    private final Integer limit;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.exclusiveStartTableName = builder.exclusiveStartTableName;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The first table name that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.
     * </p>
     * 
     * @return The first table name that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of
     *         results.
     */
    public final String exclusiveStartTableName() {
        return exclusiveStartTableName;
    }

    /**
     * <p>
     * A maximum number of table names to return. If this parameter is not specified, the limit is 100.
     * </p>
     * 
     * @return A maximum number of table names to return. If this parameter is not specified, the limit is 100.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartTableName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest) obj;
        return Objects.equals(exclusiveStartTableName(), other.exclusiveStartTableName())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTablesRequest").add("ExclusiveStartTableName", exclusiveStartTableName())
                .add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExclusiveStartTableName":
            return Optional.ofNullable(clazz.cast(exclusiveStartTableName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExclusiveStartTableName", EXCLUSIVE_START_TABLE_NAME_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesRequest> {
        /**
         * <p>
         * The first table name that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of results.
         * </p>
         * 
         * @param exclusiveStartTableName
         *        The first table name that this operation will evaluate. Use the value that was returned for
         *        <code>LastEvaluatedTableName</code> in a previous operation, so that you can obtain the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartTableName(String exclusiveStartTableName);

        /**
         * <p>
         * A maximum number of table names to return. If this parameter is not specified, the limit is 100.
         * </p>
         * 
         * @param limit
         *        A maximum number of table names to return. If this parameter is not specified, the limit is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String exclusiveStartTableName;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            exclusiveStartTableName(model.exclusiveStartTableName);
            limit(model.limit);
        }

        public final String getExclusiveStartTableName() {
            return exclusiveStartTableName;
        }

        public final void setExclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
        }

        @Override
        public final Builder exclusiveStartTableName(String exclusiveStartTableName) {
            this.exclusiveStartTableName = exclusiveStartTableName;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
