/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ExecuteStatementResponse.Builder, ExecuteStatementResponse> {
    private static final SdkField<List<Map<String, AttributeValue>>> ITEMS_FIELD = SdkField
            .<List<Map<String, AttributeValue>>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ExecuteStatementResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, AttributeValue>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AttributeValue::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ExecuteStatementResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField
            .<ConsumedCapacity> builder(MarshallingType.SDK_POJO).memberName("ConsumedCapacity")
            .getter(getter(ExecuteStatementResponse::consumedCapacity)).setter(setter(Builder::consumedCapacity))
            .constructor(ConsumedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()).build();

    private static final SdkField<Map<String, AttributeValue>> LAST_EVALUATED_KEY_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .memberName("LastEvaluatedKey")
            .getter(getter(ExecuteStatementResponse::lastEvaluatedKey))
            .setter(setter(Builder::lastEvaluatedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedKey").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD,
            CONSUMED_CAPACITY_FIELD, LAST_EVALUATED_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Map<String, AttributeValue>> items;

    private final String nextToken;

    private final ConsumedCapacity consumedCapacity;

    private final Map<String, AttributeValue> lastEvaluatedKey;

    private ExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
        this.consumedCapacity = builder.consumedCapacity;
        this.lastEvaluatedKey = builder.lastEvaluatedKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If a read operation was used, this property will contain the result of the read operation; a map of attribute
     * names and their values. For the write operations this value will be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return If a read operation was used, this property will contain the result of the read operation; a map of
     *         attribute names and their values. For the write operations this value will be empty.
     */
    public final List<Map<String, AttributeValue>> items() {
        return items;
    }

    /**
     * <p>
     * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
     * response. If set, you can use that this value in the subsequent request to get the remaining results.
     * </p>
     * 
     * @return If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
     *         response. If set, you can use that this value in the subsequent request to get the remaining results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns the value of the ConsumedCapacity property for this object.
     * 
     * @return The value of the ConsumedCapacity property for this object.
     */
    public final ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the LastEvaluatedKey property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLastEvaluatedKey() {
        return lastEvaluatedKey != null && !(lastEvaluatedKey instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to
     * start a new operation, excluding this value in the new request. If <code>LastEvaluatedKey</code> is empty, then
     * the "last page" of results has been processed and there is no more data to be retrieved. If
     * <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the result
     * set. The only way to know when you have reached the end of the result set is when <code>LastEvaluatedKey</code>
     * is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLastEvaluatedKey} method.
     * </p>
     * 
     * @return The primary key of the item where the operation stopped, inclusive of the previous result set. Use this
     *         value to start a new operation, excluding this value in the new request. If <code>LastEvaluatedKey</code>
     *         is empty, then the "last page" of results has been processed and there is no more data to be retrieved.
     *         If <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in
     *         the result set. The only way to know when you have reached the end of the result set is when
     *         <code>LastEvaluatedKey</code> is empty.
     */
    public final Map<String, AttributeValue> lastEvaluatedKey() {
        return lastEvaluatedKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasLastEvaluatedKey() ? lastEvaluatedKey() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementResponse)) {
            return false;
        }
        ExecuteStatementResponse other = (ExecuteStatementResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(consumedCapacity(), other.consumedCapacity())
                && hasLastEvaluatedKey() == other.hasLastEvaluatedKey()
                && Objects.equals(lastEvaluatedKey(), other.lastEvaluatedKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).add("ConsumedCapacity", consumedCapacity())
                .add("LastEvaluatedKey", hasLastEvaluatedKey() ? lastEvaluatedKey() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        case "LastEvaluatedKey":
            return Optional.ofNullable(clazz.cast(lastEvaluatedKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Items", ITEMS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ConsumedCapacity", CONSUMED_CAPACITY_FIELD);
        map.put("LastEvaluatedKey", LAST_EVALUATED_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementResponse, T> g) {
        return obj -> g.apply((ExecuteStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementResponse> {
        /**
         * <p>
         * If a read operation was used, this property will contain the result of the read operation; a map of attribute
         * names and their values. For the write operations this value will be empty.
         * </p>
         * 
         * @param items
         *        If a read operation was used, this property will contain the result of the read operation; a map of
         *        attribute names and their values. For the write operations this value will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<? extends Map<String, AttributeValue>> items);

        /**
         * <p>
         * If a read operation was used, this property will contain the result of the read operation; a map of attribute
         * names and their values. For the write operations this value will be empty.
         * </p>
         * 
         * @param items
         *        If a read operation was used, this property will contain the result of the read operation; a map of
         *        attribute names and their values. For the write operations this value will be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Map<String, AttributeValue>... items);

        /**
         * <p>
         * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the
         * response. If set, you can use that this value in the subsequent request to get the remaining results.
         * </p>
         * 
         * @param nextToken
         *        If the response of a read request exceeds the response payload limit DynamoDB will set this value in
         *        the response. If set, you can use that this value in the subsequent request to get the remaining
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * Sets the value of the ConsumedCapacity property for this object.
         *
         * @param consumedCapacity
         *        The new value for the ConsumedCapacity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * Sets the value of the ConsumedCapacity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the
         * need to create one manually via {@link ConsumedCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().applyMutation(consumedCapacity).build());
        }

        /**
         * <p>
         * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value
         * to start a new operation, excluding this value in the new request. If <code>LastEvaluatedKey</code> is empty,
         * then the "last page" of results has been processed and there is no more data to be retrieved. If
         * <code>LastEvaluatedKey</code> is not empty, it does not necessarily mean that there is more data in the
         * result set. The only way to know when you have reached the end of the result set is when
         * <code>LastEvaluatedKey</code> is empty.
         * </p>
         * 
         * @param lastEvaluatedKey
         *        The primary key of the item where the operation stopped, inclusive of the previous result set. Use
         *        this value to start a new operation, excluding this value in the new request. If
         *        <code>LastEvaluatedKey</code> is empty, then the "last page" of results has been processed and there
         *        is no more data to be retrieved. If <code>LastEvaluatedKey</code> is not empty, it does not
         *        necessarily mean that there is more data in the result set. The only way to know when you have reached
         *        the end of the result set is when <code>LastEvaluatedKey</code> is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<Map<String, AttributeValue>> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private ConsumedCapacity consumedCapacity;

        private Map<String, AttributeValue> lastEvaluatedKey = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
            consumedCapacity(model.consumedCapacity);
            lastEvaluatedKey(model.lastEvaluatedKey);
        }

        public final List<Map<String, AttributeValue.Builder>> getItems() {
            List<Map<String, AttributeValue.Builder>> result = ItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<? extends Map<String, AttributeValue.BuilderImpl>> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<? extends Map<String, AttributeValue>> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Map<String, AttributeValue>... items) {
            items(Arrays.asList(items));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getLastEvaluatedKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.lastEvaluatedKey);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLastEvaluatedKey(Map<String, AttributeValue.BuilderImpl> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copyFromBuilder(lastEvaluatedKey);
        }

        @Override
        public final Builder lastEvaluatedKey(Map<String, AttributeValue> lastEvaluatedKey) {
            this.lastEvaluatedKey = KeyCopier.copy(lastEvaluatedKey);
            return this;
        }

        @Override
        public ExecuteStatementResponse build() {
            return new ExecuteStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
