/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the properties of a witness Region in a MRSC global table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlobalTableWitnessDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<GlobalTableWitnessDescription.Builder, GlobalTableWitnessDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(GlobalTableWitnessDescription::regionName))
            .setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> WITNESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WitnessStatus").getter(getter(GlobalTableWitnessDescription::witnessStatusAsString))
            .setter(setter(Builder::witnessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WitnessStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD,
            WITNESS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regionName;

    private final String witnessStatus;

    private GlobalTableWitnessDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.witnessStatus = builder.witnessStatus;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Region that serves as a witness for the MRSC global table.
     * </p>
     * 
     * @return The name of the Amazon Web Services Region that serves as a witness for the MRSC global table.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The current status of the witness Region in the MRSC global table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #witnessStatus}
     * will return {@link WitnessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #witnessStatusAsString}.
     * </p>
     * 
     * @return The current status of the witness Region in the MRSC global table.
     * @see WitnessStatus
     */
    public final WitnessStatus witnessStatus() {
        return WitnessStatus.fromValue(witnessStatus);
    }

    /**
     * <p>
     * The current status of the witness Region in the MRSC global table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #witnessStatus}
     * will return {@link WitnessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #witnessStatusAsString}.
     * </p>
     * 
     * @return The current status of the witness Region in the MRSC global table.
     * @see WitnessStatus
     */
    public final String witnessStatusAsString() {
        return witnessStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(witnessStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableWitnessDescription)) {
            return false;
        }
        GlobalTableWitnessDescription other = (GlobalTableWitnessDescription) obj;
        return Objects.equals(regionName(), other.regionName())
                && Objects.equals(witnessStatusAsString(), other.witnessStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlobalTableWitnessDescription").add("RegionName", regionName())
                .add("WitnessStatus", witnessStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "WitnessStatus":
            return Optional.ofNullable(clazz.cast(witnessStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("WitnessStatus", WITNESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableWitnessDescription, T> g) {
        return obj -> g.apply((GlobalTableWitnessDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlobalTableWitnessDescription> {
        /**
         * <p>
         * The name of the Amazon Web Services Region that serves as a witness for the MRSC global table.
         * </p>
         * 
         * @param regionName
         *        The name of the Amazon Web Services Region that serves as a witness for the MRSC global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The current status of the witness Region in the MRSC global table.
         * </p>
         * 
         * @param witnessStatus
         *        The current status of the witness Region in the MRSC global table.
         * @see WitnessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WitnessStatus
         */
        Builder witnessStatus(String witnessStatus);

        /**
         * <p>
         * The current status of the witness Region in the MRSC global table.
         * </p>
         * 
         * @param witnessStatus
         *        The current status of the witness Region in the MRSC global table.
         * @see WitnessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WitnessStatus
         */
        Builder witnessStatus(WitnessStatus witnessStatus);
    }

    static final class BuilderImpl implements Builder {
        private String regionName;

        private String witnessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableWitnessDescription model) {
            regionName(model.regionName);
            witnessStatus(model.witnessStatus);
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getWitnessStatus() {
            return witnessStatus;
        }

        public final void setWitnessStatus(String witnessStatus) {
            this.witnessStatus = witnessStatus;
        }

        @Override
        public final Builder witnessStatus(String witnessStatus) {
            this.witnessStatus = witnessStatus;
            return this;
        }

        @Override
        public final Builder witnessStatus(WitnessStatus witnessStatus) {
            this.witnessStatus(witnessStatus == null ? null : witnessStatus.toString());
            return this;
        }

        @Override
        public GlobalTableWitnessDescription build() {
            return new GlobalTableWitnessDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
