/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.CapacityProviderField;
import software.amazon.awssdk.services.ecs.model.CapacityProviderFieldListCopier;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityProvidersRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, DescribeCapacityProvidersRequest> {
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capacityProviders").getter(DescribeCapacityProvidersRequest.getter(DescribeCapacityProvidersRequest::capacityProviders)).setter(DescribeCapacityProvidersRequest.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("include").getter(DescribeCapacityProvidersRequest.getter(DescribeCapacityProvidersRequest::includeAsStrings)).setter(DescribeCapacityProvidersRequest.setter(Builder::includeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeCapacityProvidersRequest.getter(DescribeCapacityProvidersRequest::maxResults)).setter(DescribeCapacityProvidersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeCapacityProvidersRequest.getter(DescribeCapacityProvidersRequest::nextToken)).setter(DescribeCapacityProvidersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDERS_FIELD, INCLUDE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> capacityProviders;
    private final List<String> include;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeCapacityProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.capacityProviders = builder.capacityProviders;
        this.include = builder.include;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public List<CapacityProviderField> include() {
        return CapacityProviderFieldListCopier.copyStringToEnum(this.include);
    }

    public boolean hasInclude() {
        return this.include != null && !(this.include instanceof SdkAutoConstructList);
    }

    public List<String> includeAsStrings() {
        return this.include;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclude() ? this.includeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityProvidersRequest)) {
            return false;
        }
        DescribeCapacityProvidersRequest other = (DescribeCapacityProvidersRequest)((Object)obj);
        return this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasInclude() == other.hasInclude() && Objects.equals(this.includeAsStrings(), other.includeAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCapacityProvidersRequest").add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("Include", this.hasInclude() ? this.includeAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "capacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "include": {
                return Optional.ofNullable(clazz.cast(this.includeAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityProvidersRequest, T> g) {
        return obj -> g.apply((DescribeCapacityProvidersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> include = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityProvidersRequest model) {
            super(model);
            this.capacityProviders(model.capacityProviders);
            this.includeWithStrings(model.include);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getCapacityProviders() {
            if (this.capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviders;
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = StringListCopier.copy(capacityProviders);
        }

        public final Collection<String> getInclude() {
            if (this.include instanceof SdkAutoConstructList) {
                return null;
            }
            return this.include;
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = CapacityProviderFieldListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String ... include) {
            this.includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<CapacityProviderField> include) {
            this.include = CapacityProviderFieldListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(CapacityProviderField ... include) {
            this.include(Arrays.asList(include));
            return this;
        }

        public final void setInclude(Collection<String> include) {
            this.include = CapacityProviderFieldListCopier.copy(include);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCapacityProvidersRequest build() {
            return new DescribeCapacityProvidersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityProvidersRequest> {
        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder includeWithStrings(Collection<String> var1);

        public Builder includeWithStrings(String ... var1);

        public Builder include(Collection<CapacityProviderField> var1);

        public Builder include(CapacityProviderField ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

