/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.FirelensConfigurationOptionsMapCopier;
import software.amazon.awssdk.services.ecs.model.FirelensConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirelensConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirelensConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FirelensConfiguration.getter(FirelensConfiguration::typeAsString)).setter(FirelensConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("options").getter(FirelensConfiguration.getter(FirelensConfiguration::options)).setter(FirelensConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Map<String, String> options;

    private FirelensConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.options = builder.options;
    }

    public FirelensConfigurationType type() {
        return FirelensConfigurationType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructMap);
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirelensConfiguration)) {
            return false;
        }
        FirelensConfiguration other = (FirelensConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public String toString() {
        return ToString.builder((String)"FirelensConfiguration").add("Type", (Object)this.typeAsString()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirelensConfiguration, T> g) {
        return obj -> g.apply((FirelensConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FirelensConfiguration model) {
            this.type(model.type);
            this.options(model.options);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FirelensConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Map<String, String> getOptions() {
            if (this.options instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = FirelensConfigurationOptionsMapCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = FirelensConfigurationOptionsMapCopier.copy(options);
        }

        public FirelensConfiguration build() {
            return new FirelensConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirelensConfiguration> {
        public Builder type(String var1);

        public Builder type(FirelensConfigurationType var1);

        public Builder options(Map<String, String> var1);
    }
}

