/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.SortOrder;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTaskDefinitionsRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, ListTaskDefinitionsRequest> {
    private static final SdkField<String> FAMILY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("familyPrefix").getter(ListTaskDefinitionsRequest.getter(ListTaskDefinitionsRequest::familyPrefix)).setter(ListTaskDefinitionsRequest.setter(Builder::familyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("familyPrefix").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListTaskDefinitionsRequest.getter(ListTaskDefinitionsRequest::statusAsString)).setter(ListTaskDefinitionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sort").getter(ListTaskDefinitionsRequest.getter(ListTaskDefinitionsRequest::sortAsString)).setter(ListTaskDefinitionsRequest.setter(Builder::sort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTaskDefinitionsRequest.getter(ListTaskDefinitionsRequest::nextToken)).setter(ListTaskDefinitionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTaskDefinitionsRequest.getter(ListTaskDefinitionsRequest::maxResults)).setter(ListTaskDefinitionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_PREFIX_FIELD, STATUS_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String familyPrefix;
    private final String status;
    private final String sort;
    private final String nextToken;
    private final Integer maxResults;

    private ListTaskDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.familyPrefix = builder.familyPrefix;
        this.status = builder.status;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String familyPrefix() {
        return this.familyPrefix;
    }

    public TaskDefinitionStatus status() {
        return TaskDefinitionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public SortOrder sort() {
        return SortOrder.fromValue(this.sort);
    }

    public String sortAsString() {
        return this.sort;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.familyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTaskDefinitionsRequest)) {
            return false;
        }
        ListTaskDefinitionsRequest other = (ListTaskDefinitionsRequest)((Object)obj);
        return Objects.equals(this.familyPrefix(), other.familyPrefix()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sortAsString(), other.sortAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListTaskDefinitionsRequest").add("FamilyPrefix", (Object)this.familyPrefix()).add("Status", (Object)this.statusAsString()).add("Sort", (Object)this.sortAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "familyPrefix": {
                return Optional.ofNullable(clazz.cast(this.familyPrefix()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sortAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTaskDefinitionsRequest, T> g) {
        return obj -> g.apply((ListTaskDefinitionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String familyPrefix;
        private String status;
        private String sort;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTaskDefinitionsRequest model) {
            super(model);
            this.familyPrefix(model.familyPrefix);
            this.status(model.status);
            this.sort(model.sort);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getFamilyPrefix() {
            return this.familyPrefix;
        }

        @Override
        public final Builder familyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
            return this;
        }

        public final void setFamilyPrefix(String familyPrefix) {
            this.familyPrefix = familyPrefix;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskDefinitionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSort() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(SortOrder sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTaskDefinitionsRequest build() {
            return new ListTaskDefinitionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTaskDefinitionsRequest> {
        public Builder familyPrefix(String var1);

        public Builder status(String var1);

        public Builder status(TaskDefinitionStatus var1);

        public Builder sort(String var1);

        public Builder sort(SortOrder var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

