/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecs.EcsAsyncClient;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse;

public class ListTaskDefinitionFamiliesPublisher
implements SdkPublisher<ListTaskDefinitionFamiliesResponse> {
    private final EcsAsyncClient client;
    private final ListTaskDefinitionFamiliesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTaskDefinitionFamiliesPublisher(EcsAsyncClient client, ListTaskDefinitionFamiliesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTaskDefinitionFamiliesPublisher(EcsAsyncClient client, ListTaskDefinitionFamiliesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTaskDefinitionFamiliesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTaskDefinitionFamiliesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> families() {
        Function<ListTaskDefinitionFamiliesResponse, Iterator> getIterator = response -> {
            if (response != null && response.families() != null) {
                return response.families().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTaskDefinitionFamiliesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTaskDefinitionFamiliesResponseFetcher
    implements AsyncPageFetcher<ListTaskDefinitionFamiliesResponse> {
        private ListTaskDefinitionFamiliesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTaskDefinitionFamiliesResponse> nextPage(ListTaskDefinitionFamiliesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskDefinitionFamiliesPublisher.this.client.listTaskDefinitionFamilies(ListTaskDefinitionFamiliesPublisher.this.firstRequest);
            }
            return ListTaskDefinitionFamiliesPublisher.this.client.listTaskDefinitionFamilies((ListTaskDefinitionFamiliesRequest)((Object)ListTaskDefinitionFamiliesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

