/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcLatticeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcLatticeConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(VpcLatticeConfiguration.getter(VpcLatticeConfiguration::roleArn)).setter(VpcLatticeConfiguration.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetGroupArn").getter(VpcLatticeConfiguration.getter(VpcLatticeConfiguration::targetGroupArn)).setter(VpcLatticeConfiguration.setter(Builder::targetGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArn").build()}).build();
    private static final SdkField<String> PORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portName").getter(VpcLatticeConfiguration.getter(VpcLatticeConfiguration::portName)).setter(VpcLatticeConfiguration.setter(Builder::portName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, TARGET_GROUP_ARN_FIELD, PORT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcLatticeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String targetGroupArn;
    private final String portName;

    private VpcLatticeConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.targetGroupArn = builder.targetGroupArn;
        this.portName = builder.portName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String targetGroupArn() {
        return this.targetGroupArn;
    }

    public final String portName() {
        return this.portName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcLatticeConfiguration)) {
            return false;
        }
        VpcLatticeConfiguration other = (VpcLatticeConfiguration)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.targetGroupArn(), other.targetGroupArn()) && Objects.equals(this.portName(), other.portName());
    }

    public final String toString() {
        return ToString.builder((String)"VpcLatticeConfiguration").add("RoleArn", (Object)this.roleArn()).add("TargetGroupArn", (Object)this.targetGroupArn()).add("PortName", (Object)this.portName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "targetGroupArn": {
                return Optional.ofNullable(clazz.cast(this.targetGroupArn()));
            }
            case "portName": {
                return Optional.ofNullable(clazz.cast(this.portName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("targetGroupArn", TARGET_GROUP_ARN_FIELD);
        map.put("portName", PORT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcLatticeConfiguration, T> g) {
        return obj -> g.apply((VpcLatticeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String targetGroupArn;
        private String portName;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcLatticeConfiguration model) {
            this.roleArn(model.roleArn);
            this.targetGroupArn(model.targetGroupArn);
            this.portName(model.portName);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTargetGroupArn() {
            return this.targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final String getPortName() {
            return this.portName;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public VpcLatticeConfiguration build() {
            return new VpcLatticeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcLatticeConfiguration> {
        public Builder roleArn(String var1);

        public Builder targetGroupArn(String var1);

        public Builder portName(String var1);
    }
}

