/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.efs.model.CreationInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RootDirectory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RootDirectory> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(RootDirectory.getter(RootDirectory::path)).setter(RootDirectory.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<CreationInfo> CREATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreationInfo").getter(RootDirectory.getter(RootDirectory::creationInfo)).setter(RootDirectory.setter(Builder::creationInfo)).constructor(CreationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, CREATION_INFO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RootDirectory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String path;
    private final CreationInfo creationInfo;

    private RootDirectory(BuilderImpl builder) {
        this.path = builder.path;
        this.creationInfo = builder.creationInfo;
    }

    public final String path() {
        return this.path;
    }

    public final CreationInfo creationInfo() {
        return this.creationInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootDirectory)) {
            return false;
        }
        RootDirectory other = (RootDirectory)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.creationInfo(), other.creationInfo());
    }

    public final String toString() {
        return ToString.builder((String)"RootDirectory").add("Path", (Object)this.path()).add("CreationInfo", (Object)this.creationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "CreationInfo": {
                return Optional.ofNullable(clazz.cast(this.creationInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Path", PATH_FIELD);
        map.put("CreationInfo", CREATION_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RootDirectory, T> g) {
        return obj -> g.apply((RootDirectory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private CreationInfo creationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RootDirectory model) {
            this.path(model.path);
            this.creationInfo(model.creationInfo);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final CreationInfo.Builder getCreationInfo() {
            return this.creationInfo != null ? this.creationInfo.toBuilder() : null;
        }

        public final void setCreationInfo(CreationInfo.BuilderImpl creationInfo) {
            this.creationInfo = creationInfo != null ? creationInfo.build() : null;
        }

        @Override
        public final Builder creationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public RootDirectory build() {
            return new RootDirectory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RootDirectory> {
        public Builder path(String var1);

        public Builder creationInfo(CreationInfo var1);

        default public Builder creationInfo(Consumer<CreationInfo.Builder> creationInfo) {
            return this.creationInfo((CreationInfo)((CreationInfo.Builder)CreationInfo.builder().applyMutation(creationInfo)).build());
        }
    }
}

