/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The status of the service update on the cache node
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CacheNodeUpdateStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CacheNodeUpdateStatus.Builder, CacheNodeUpdateStatus> {
    private static final SdkField<String> CACHE_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheNodeId").getter(getter(CacheNodeUpdateStatus::cacheNodeId)).setter(setter(Builder::cacheNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeId").build()).build();

    private static final SdkField<String> NODE_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeUpdateStatus").getter(getter(CacheNodeUpdateStatus::nodeUpdateStatusAsString))
            .setter(setter(Builder::nodeUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatus").build()).build();

    private static final SdkField<Instant> NODE_DELETION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeDeletionDate").getter(getter(CacheNodeUpdateStatus::nodeDeletionDate))
            .setter(setter(Builder::nodeDeletionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDeletionDate").build()).build();

    private static final SdkField<Instant> NODE_UPDATE_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateStartDate").getter(getter(CacheNodeUpdateStatus::nodeUpdateStartDate))
            .setter(setter(Builder::nodeUpdateStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStartDate").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_END_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateEndDate").getter(getter(CacheNodeUpdateStatus::nodeUpdateEndDate))
            .setter(setter(Builder::nodeUpdateEndDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateEndDate").build()).build();

    private static final SdkField<String> NODE_UPDATE_INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeUpdateInitiatedBy").getter(getter(CacheNodeUpdateStatus::nodeUpdateInitiatedByAsString))
            .setter(setter(Builder::nodeUpdateInitiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedBy").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_INITIATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateInitiatedDate").getter(getter(CacheNodeUpdateStatus::nodeUpdateInitiatedDate))
            .setter(setter(Builder::nodeUpdateInitiatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateInitiatedDate").build())
            .build();

    private static final SdkField<Instant> NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NodeUpdateStatusModifiedDate")
            .getter(getter(CacheNodeUpdateStatus::nodeUpdateStatusModifiedDate))
            .setter(setter(Builder::nodeUpdateStatusModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeUpdateStatusModifiedDate")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_NODE_ID_FIELD,
            NODE_UPDATE_STATUS_FIELD, NODE_DELETION_DATE_FIELD, NODE_UPDATE_START_DATE_FIELD, NODE_UPDATE_END_DATE_FIELD,
            NODE_UPDATE_INITIATED_BY_FIELD, NODE_UPDATE_INITIATED_DATE_FIELD, NODE_UPDATE_STATUS_MODIFIED_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheNodeId;

    private final String nodeUpdateStatus;

    private final Instant nodeDeletionDate;

    private final Instant nodeUpdateStartDate;

    private final Instant nodeUpdateEndDate;

    private final String nodeUpdateInitiatedBy;

    private final Instant nodeUpdateInitiatedDate;

    private final Instant nodeUpdateStatusModifiedDate;

    private CacheNodeUpdateStatus(BuilderImpl builder) {
        this.cacheNodeId = builder.cacheNodeId;
        this.nodeUpdateStatus = builder.nodeUpdateStatus;
        this.nodeDeletionDate = builder.nodeDeletionDate;
        this.nodeUpdateStartDate = builder.nodeUpdateStartDate;
        this.nodeUpdateEndDate = builder.nodeUpdateEndDate;
        this.nodeUpdateInitiatedBy = builder.nodeUpdateInitiatedBy;
        this.nodeUpdateInitiatedDate = builder.nodeUpdateInitiatedDate;
        this.nodeUpdateStatusModifiedDate = builder.nodeUpdateStatusModifiedDate;
    }

    /**
     * <p>
     * The node ID of the cache cluster
     * </p>
     * 
     * @return The node ID of the cache cluster
     */
    public final String cacheNodeId() {
        return cacheNodeId;
    }

    /**
     * <p>
     * The update status of the node
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeUpdateStatus}
     * will return {@link NodeUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeUpdateStatusAsString}.
     * </p>
     * 
     * @return The update status of the node
     * @see NodeUpdateStatus
     */
    public final NodeUpdateStatus nodeUpdateStatus() {
        return NodeUpdateStatus.fromValue(nodeUpdateStatus);
    }

    /**
     * <p>
     * The update status of the node
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeUpdateStatus}
     * will return {@link NodeUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeUpdateStatusAsString}.
     * </p>
     * 
     * @return The update status of the node
     * @see NodeUpdateStatus
     */
    public final String nodeUpdateStatusAsString() {
        return nodeUpdateStatus;
    }

    /**
     * <p>
     * The deletion date of the node
     * </p>
     * 
     * @return The deletion date of the node
     */
    public final Instant nodeDeletionDate() {
        return nodeDeletionDate;
    }

    /**
     * <p>
     * The start date of the update for a node
     * </p>
     * 
     * @return The start date of the update for a node
     */
    public final Instant nodeUpdateStartDate() {
        return nodeUpdateStartDate;
    }

    /**
     * <p>
     * The end date of the update for a node
     * </p>
     * 
     * @return The end date of the update for a node
     */
    public final Instant nodeUpdateEndDate() {
        return nodeUpdateEndDate;
    }

    /**
     * <p>
     * Reflects whether the update was initiated by the customer or automatically applied
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeUpdateInitiatedBy} will return {@link NodeUpdateInitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeUpdateInitiatedByAsString}.
     * </p>
     * 
     * @return Reflects whether the update was initiated by the customer or automatically applied
     * @see NodeUpdateInitiatedBy
     */
    public final NodeUpdateInitiatedBy nodeUpdateInitiatedBy() {
        return NodeUpdateInitiatedBy.fromValue(nodeUpdateInitiatedBy);
    }

    /**
     * <p>
     * Reflects whether the update was initiated by the customer or automatically applied
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeUpdateInitiatedBy} will return {@link NodeUpdateInitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #nodeUpdateInitiatedByAsString}.
     * </p>
     * 
     * @return Reflects whether the update was initiated by the customer or automatically applied
     * @see NodeUpdateInitiatedBy
     */
    public final String nodeUpdateInitiatedByAsString() {
        return nodeUpdateInitiatedBy;
    }

    /**
     * <p>
     * The date when the update is triggered
     * </p>
     * 
     * @return The date when the update is triggered
     */
    public final Instant nodeUpdateInitiatedDate() {
        return nodeUpdateInitiatedDate;
    }

    /**
     * <p>
     * The date when the NodeUpdateStatus was last modified&gt;
     * </p>
     * 
     * @return The date when the NodeUpdateStatus was last modified&gt;
     */
    public final Instant nodeUpdateStatusModifiedDate() {
        return nodeUpdateStatusModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeDeletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateInitiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateInitiatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(nodeUpdateStatusModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheNodeUpdateStatus)) {
            return false;
        }
        CacheNodeUpdateStatus other = (CacheNodeUpdateStatus) obj;
        return Objects.equals(cacheNodeId(), other.cacheNodeId())
                && Objects.equals(nodeUpdateStatusAsString(), other.nodeUpdateStatusAsString())
                && Objects.equals(nodeDeletionDate(), other.nodeDeletionDate())
                && Objects.equals(nodeUpdateStartDate(), other.nodeUpdateStartDate())
                && Objects.equals(nodeUpdateEndDate(), other.nodeUpdateEndDate())
                && Objects.equals(nodeUpdateInitiatedByAsString(), other.nodeUpdateInitiatedByAsString())
                && Objects.equals(nodeUpdateInitiatedDate(), other.nodeUpdateInitiatedDate())
                && Objects.equals(nodeUpdateStatusModifiedDate(), other.nodeUpdateStatusModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CacheNodeUpdateStatus").add("CacheNodeId", cacheNodeId())
                .add("NodeUpdateStatus", nodeUpdateStatusAsString()).add("NodeDeletionDate", nodeDeletionDate())
                .add("NodeUpdateStartDate", nodeUpdateStartDate()).add("NodeUpdateEndDate", nodeUpdateEndDate())
                .add("NodeUpdateInitiatedBy", nodeUpdateInitiatedByAsString())
                .add("NodeUpdateInitiatedDate", nodeUpdateInitiatedDate())
                .add("NodeUpdateStatusModifiedDate", nodeUpdateStatusModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheNodeId":
            return Optional.ofNullable(clazz.cast(cacheNodeId()));
        case "NodeUpdateStatus":
            return Optional.ofNullable(clazz.cast(nodeUpdateStatusAsString()));
        case "NodeDeletionDate":
            return Optional.ofNullable(clazz.cast(nodeDeletionDate()));
        case "NodeUpdateStartDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateStartDate()));
        case "NodeUpdateEndDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateEndDate()));
        case "NodeUpdateInitiatedBy":
            return Optional.ofNullable(clazz.cast(nodeUpdateInitiatedByAsString()));
        case "NodeUpdateInitiatedDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateInitiatedDate()));
        case "NodeUpdateStatusModifiedDate":
            return Optional.ofNullable(clazz.cast(nodeUpdateStatusModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CacheNodeUpdateStatus, T> g) {
        return obj -> g.apply((CacheNodeUpdateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CacheNodeUpdateStatus> {
        /**
         * <p>
         * The node ID of the cache cluster
         * </p>
         * 
         * @param cacheNodeId
         *        The node ID of the cache cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeId(String cacheNodeId);

        /**
         * <p>
         * The update status of the node
         * </p>
         * 
         * @param nodeUpdateStatus
         *        The update status of the node
         * @see NodeUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateStatus
         */
        Builder nodeUpdateStatus(String nodeUpdateStatus);

        /**
         * <p>
         * The update status of the node
         * </p>
         * 
         * @param nodeUpdateStatus
         *        The update status of the node
         * @see NodeUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateStatus
         */
        Builder nodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus);

        /**
         * <p>
         * The deletion date of the node
         * </p>
         * 
         * @param nodeDeletionDate
         *        The deletion date of the node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDeletionDate(Instant nodeDeletionDate);

        /**
         * <p>
         * The start date of the update for a node
         * </p>
         * 
         * @param nodeUpdateStartDate
         *        The start date of the update for a node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateStartDate(Instant nodeUpdateStartDate);

        /**
         * <p>
         * The end date of the update for a node
         * </p>
         * 
         * @param nodeUpdateEndDate
         *        The end date of the update for a node
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateEndDate(Instant nodeUpdateEndDate);

        /**
         * <p>
         * Reflects whether the update was initiated by the customer or automatically applied
         * </p>
         * 
         * @param nodeUpdateInitiatedBy
         *        Reflects whether the update was initiated by the customer or automatically applied
         * @see NodeUpdateInitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateInitiatedBy
         */
        Builder nodeUpdateInitiatedBy(String nodeUpdateInitiatedBy);

        /**
         * <p>
         * Reflects whether the update was initiated by the customer or automatically applied
         * </p>
         * 
         * @param nodeUpdateInitiatedBy
         *        Reflects whether the update was initiated by the customer or automatically applied
         * @see NodeUpdateInitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeUpdateInitiatedBy
         */
        Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy nodeUpdateInitiatedBy);

        /**
         * <p>
         * The date when the update is triggered
         * </p>
         * 
         * @param nodeUpdateInitiatedDate
         *        The date when the update is triggered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate);

        /**
         * <p>
         * The date when the NodeUpdateStatus was last modified&gt;
         * </p>
         * 
         * @param nodeUpdateStatusModifiedDate
         *        The date when the NodeUpdateStatus was last modified&gt;
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String cacheNodeId;

        private String nodeUpdateStatus;

        private Instant nodeDeletionDate;

        private Instant nodeUpdateStartDate;

        private Instant nodeUpdateEndDate;

        private String nodeUpdateInitiatedBy;

        private Instant nodeUpdateInitiatedDate;

        private Instant nodeUpdateStatusModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CacheNodeUpdateStatus model) {
            cacheNodeId(model.cacheNodeId);
            nodeUpdateStatus(model.nodeUpdateStatus);
            nodeDeletionDate(model.nodeDeletionDate);
            nodeUpdateStartDate(model.nodeUpdateStartDate);
            nodeUpdateEndDate(model.nodeUpdateEndDate);
            nodeUpdateInitiatedBy(model.nodeUpdateInitiatedBy);
            nodeUpdateInitiatedDate(model.nodeUpdateInitiatedDate);
            nodeUpdateStatusModifiedDate(model.nodeUpdateStatusModifiedDate);
        }

        public final String getCacheNodeId() {
            return cacheNodeId;
        }

        @Override
        public final Builder cacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
            return this;
        }

        public final void setCacheNodeId(String cacheNodeId) {
            this.cacheNodeId = cacheNodeId;
        }

        public final String getNodeUpdateStatus() {
            return nodeUpdateStatus;
        }

        @Override
        public final Builder nodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
            return this;
        }

        @Override
        public final Builder nodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus) {
            this.nodeUpdateStatus(nodeUpdateStatus == null ? null : nodeUpdateStatus.toString());
            return this;
        }

        public final void setNodeUpdateStatus(String nodeUpdateStatus) {
            this.nodeUpdateStatus = nodeUpdateStatus;
        }

        public final Instant getNodeDeletionDate() {
            return nodeDeletionDate;
        }

        @Override
        public final Builder nodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
            return this;
        }

        public final void setNodeDeletionDate(Instant nodeDeletionDate) {
            this.nodeDeletionDate = nodeDeletionDate;
        }

        public final Instant getNodeUpdateStartDate() {
            return nodeUpdateStartDate;
        }

        @Override
        public final Builder nodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
            return this;
        }

        public final void setNodeUpdateStartDate(Instant nodeUpdateStartDate) {
            this.nodeUpdateStartDate = nodeUpdateStartDate;
        }

        public final Instant getNodeUpdateEndDate() {
            return nodeUpdateEndDate;
        }

        @Override
        public final Builder nodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
            return this;
        }

        public final void setNodeUpdateEndDate(Instant nodeUpdateEndDate) {
            this.nodeUpdateEndDate = nodeUpdateEndDate;
        }

        public final String getNodeUpdateInitiatedBy() {
            return nodeUpdateInitiatedBy;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
            return this;
        }

        @Override
        public final Builder nodeUpdateInitiatedBy(NodeUpdateInitiatedBy nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy(nodeUpdateInitiatedBy == null ? null : nodeUpdateInitiatedBy.toString());
            return this;
        }

        public final void setNodeUpdateInitiatedBy(String nodeUpdateInitiatedBy) {
            this.nodeUpdateInitiatedBy = nodeUpdateInitiatedBy;
        }

        public final Instant getNodeUpdateInitiatedDate() {
            return nodeUpdateInitiatedDate;
        }

        @Override
        public final Builder nodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
            return this;
        }

        public final void setNodeUpdateInitiatedDate(Instant nodeUpdateInitiatedDate) {
            this.nodeUpdateInitiatedDate = nodeUpdateInitiatedDate;
        }

        public final Instant getNodeUpdateStatusModifiedDate() {
            return nodeUpdateStatusModifiedDate;
        }

        @Override
        public final Builder nodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
            return this;
        }

        public final void setNodeUpdateStatusModifiedDate(Instant nodeUpdateStatusModifiedDate) {
            this.nodeUpdateStatusModifiedDate = nodeUpdateStatusModifiedDate;
        }

        @Override
        public CacheNodeUpdateStatus build() {
            return new CacheNodeUpdateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
