/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>CreateCacheSecurityGroup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCacheSecurityGroupRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<CreateCacheSecurityGroupRequest.Builder, CreateCacheSecurityGroupRequest> {
    private static final SdkField<String> CACHE_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheSecurityGroupName").getter(getter(CreateCacheSecurityGroupRequest::cacheSecurityGroupName))
            .setter(setter(Builder::cacheSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheSecurityGroupName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCacheSecurityGroupRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCacheSecurityGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CACHE_SECURITY_GROUP_NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private final String cacheSecurityGroupName;

    private final String description;

    private final List<Tag> tags;

    private CreateCacheSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.cacheSecurityGroupName = builder.cacheSecurityGroupName;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the cache security group. This value is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".
     * </p>
     * <p>
     * Example: <code>mysecuritygroup</code>
     * </p>
     * 
     * @return A name for the cache security group. This value is stored as a lowercase string.</p>
     *         <p>
     *         Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".
     *         </p>
     *         <p>
     *         Example: <code>mysecuritygroup</code>
     */
    public final String cacheSecurityGroupName() {
        return cacheSecurityGroupName;
    }

    /**
     * <p>
     * A description for the cache security group.
     * </p>
     * 
     * @return A description for the cache security group.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag
     * value, although null is accepted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by
     *         a tag value, although null is accepted.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCacheSecurityGroupRequest)) {
            return false;
        }
        CreateCacheSecurityGroupRequest other = (CreateCacheSecurityGroupRequest) obj;
        return Objects.equals(cacheSecurityGroupName(), other.cacheSecurityGroupName())
                && Objects.equals(description(), other.description()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCacheSecurityGroupRequest").add("CacheSecurityGroupName", cacheSecurityGroupName())
                .add("Description", description()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheSecurityGroupName":
            return Optional.ofNullable(clazz.cast(cacheSecurityGroupName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCacheSecurityGroupRequest, T> g) {
        return obj -> g.apply((CreateCacheSecurityGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCacheSecurityGroupRequest> {
        /**
         * <p>
         * A name for the cache security group. This value is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".
         * </p>
         * <p>
         * Example: <code>mysecuritygroup</code>
         * </p>
         * 
         * @param cacheSecurityGroupName
         *        A name for the cache security group. This value is stored as a lowercase string.</p>
         *        <p>
         *        Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".
         *        </p>
         *        <p>
         *        Example: <code>mysecuritygroup</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheSecurityGroupName(String cacheSecurityGroupName);

        /**
         * <p>
         * A description for the cache security group.
         * </p>
         * 
         * @param description
         *        A description for the cache security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * 
         * @param tags
         *        A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied
         *        by a tag value, although null is accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a
         * tag value, although null is accepted.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheSecurityGroupName;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCacheSecurityGroupRequest model) {
            super(model);
            cacheSecurityGroupName(model.cacheSecurityGroupName);
            description(model.description);
            tags(model.tags);
        }

        public final String getCacheSecurityGroupName() {
            return cacheSecurityGroupName;
        }

        @Override
        public final Builder cacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
            return this;
        }

        public final void setCacheSecurityGroupName(String cacheSecurityGroupName) {
            this.cacheSecurityGroupName = cacheSecurityGroupName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCacheSecurityGroupRequest build() {
            return new CreateCacheSecurityGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
