/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class GlobalReplicationGroupListCopier {
    static List<GlobalReplicationGroup> copy(Collection<? extends GlobalReplicationGroup> globalReplicationGroupListParam) {
        List<GlobalReplicationGroup> list;
        if (globalReplicationGroupListParam == null || globalReplicationGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalReplicationGroup> modifiableList = new ArrayList<>();
            globalReplicationGroupListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GlobalReplicationGroup> copyFromBuilder(
            Collection<? extends GlobalReplicationGroup.Builder> globalReplicationGroupListParam) {
        List<GlobalReplicationGroup> list;
        if (globalReplicationGroupListParam == null || globalReplicationGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalReplicationGroup> modifiableList = new ArrayList<>();
            globalReplicationGroupListParam.forEach(entry -> {
                GlobalReplicationGroup member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<GlobalReplicationGroup.Builder> copyToBuilder(
            Collection<? extends GlobalReplicationGroup> globalReplicationGroupListParam) {
        List<GlobalReplicationGroup.Builder> list;
        if (globalReplicationGroupListParam == null || globalReplicationGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<GlobalReplicationGroup.Builder> modifiableList = new ArrayList<>();
            globalReplicationGroupListParam.forEach(entry -> {
                GlobalReplicationGroup.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
