/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the destination, format and type of the logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogDeliveryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogDeliveryConfiguration.Builder, LogDeliveryConfiguration> {
    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(LogDeliveryConfiguration::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogType").build()).build();

    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationType").getter(getter(LogDeliveryConfiguration::destinationTypeAsString))
            .setter(setter(Builder::destinationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationType").build()).build();

    private static final SdkField<DestinationDetails> DESTINATION_DETAILS_FIELD = SdkField
            .<DestinationDetails> builder(MarshallingType.SDK_POJO).memberName("DestinationDetails")
            .getter(getter(LogDeliveryConfiguration::destinationDetails)).setter(setter(Builder::destinationDetails))
            .constructor(DestinationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationDetails").build())
            .build();

    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFormat").getter(getter(LogDeliveryConfiguration::logFormatAsString))
            .setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LogDeliveryConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(LogDeliveryConfiguration::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPE_FIELD,
            DESTINATION_TYPE_FIELD, DESTINATION_DETAILS_FIELD, LOG_FORMAT_FIELD, STATUS_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logType;

    private final String destinationType;

    private final DestinationDetails destinationDetails;

    private final String logFormat;

    private final String status;

    private final String message;

    private LogDeliveryConfiguration(BuilderImpl builder) {
        this.logType = builder.logType;
        this.destinationType = builder.destinationType;
        this.destinationDetails = builder.destinationDetails;
        this.logFormat = builder.logFormat;
        this.status = builder.status;
        this.message = builder.message;
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
     * @see DestinationType
     */
    public final DestinationType destinationType() {
        return DestinationType.fromValue(destinationType);
    }

    /**
     * <p>
     * Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationType}
     * will return {@link DestinationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationTypeAsString}.
     * </p>
     * 
     * @return Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
     * @see DestinationType
     */
    public final String destinationTypeAsString() {
        return destinationType;
    }

    /**
     * <p>
     * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     * </p>
     * 
     * @return Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     */
    public final DestinationDetails destinationDetails() {
        return destinationDetails;
    }

    /**
     * <p>
     * Returns the log format, either JSON or TEXT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Returns the log format, either JSON or TEXT.
     * @see LogFormat
     */
    public final LogFormat logFormat() {
        return LogFormat.fromValue(logFormat);
    }

    /**
     * <p>
     * Returns the log format, either JSON or TEXT.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Returns the log format, either JSON or TEXT.
     * @see LogFormat
     */
    public final String logFormatAsString() {
        return logFormat;
    }

    /**
     * <p>
     * Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> |
     * <code>modifying</code> | <code>active</code> | <code>error</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogDeliveryConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the log delivery configuration status. Values are one of <code>enabling</code> |
     *         <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
     * @see LogDeliveryConfigurationStatus
     */
    public final LogDeliveryConfigurationStatus status() {
        return LogDeliveryConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> |
     * <code>modifying</code> | <code>active</code> | <code>error</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogDeliveryConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Returns the log delivery configuration status. Values are one of <code>enabling</code> |
     *         <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
     * @see LogDeliveryConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Returns an error message for the log delivery configuration.
     * </p>
     * 
     * @return Returns an error message for the log delivery configuration.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogDeliveryConfiguration)) {
            return false;
        }
        LogDeliveryConfiguration other = (LogDeliveryConfiguration) obj;
        return Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(destinationTypeAsString(), other.destinationTypeAsString())
                && Objects.equals(destinationDetails(), other.destinationDetails())
                && Objects.equals(logFormatAsString(), other.logFormatAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogDeliveryConfiguration").add("LogType", logTypeAsString())
                .add("DestinationType", destinationTypeAsString()).add("DestinationDetails", destinationDetails())
                .add("LogFormat", logFormatAsString()).add("Status", statusAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "DestinationType":
            return Optional.ofNullable(clazz.cast(destinationTypeAsString()));
        case "DestinationDetails":
            return Optional.ofNullable(clazz.cast(destinationDetails()));
        case "LogFormat":
            return Optional.ofNullable(clazz.cast(logFormatAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogDeliveryConfiguration, T> g) {
        return obj -> g.apply((LogDeliveryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogDeliveryConfiguration> {
        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
         * </p>
         * 
         * @param logType
         *        Refers to <a href="https://redis.io/commands/slowlog">slow-log</a>.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
         * </p>
         * 
         * @param destinationType
         *        Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(String destinationType);

        /**
         * <p>
         * Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
         * </p>
         * 
         * @param destinationType
         *        Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.
         * @see DestinationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationType
         */
        Builder destinationType(DestinationType destinationType);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * 
         * @param destinationDetails
         *        Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationDetails(DestinationDetails destinationDetails);

        /**
         * <p>
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationDetails.Builder} avoiding the need to
         * create one manually via {@link DestinationDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationDetails(DestinationDetails)}.
         * 
         * @param destinationDetails
         *        a consumer that will call methods on {@link DestinationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationDetails(DestinationDetails)
         */
        default Builder destinationDetails(Consumer<DestinationDetails.Builder> destinationDetails) {
            return destinationDetails(DestinationDetails.builder().applyMutation(destinationDetails).build());
        }

        /**
         * <p>
         * Returns the log format, either JSON or TEXT.
         * </p>
         * 
         * @param logFormat
         *        Returns the log format, either JSON or TEXT.
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(String logFormat);

        /**
         * <p>
         * Returns the log format, either JSON or TEXT.
         * </p>
         * 
         * @param logFormat
         *        Returns the log format, either JSON or TEXT.
         * @see LogFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormat
         */
        Builder logFormat(LogFormat logFormat);

        /**
         * <p>
         * Returns the log delivery configuration status. Values are one of <code>enabling</code> |
         * <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
         * </p>
         * 
         * @param status
         *        Returns the log delivery configuration status. Values are one of <code>enabling</code> |
         *        <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
         * @see LogDeliveryConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDeliveryConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Returns the log delivery configuration status. Values are one of <code>enabling</code> |
         * <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
         * </p>
         * 
         * @param status
         *        Returns the log delivery configuration status. Values are one of <code>enabling</code> |
         *        <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code>
         * @see LogDeliveryConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogDeliveryConfigurationStatus
         */
        Builder status(LogDeliveryConfigurationStatus status);

        /**
         * <p>
         * Returns an error message for the log delivery configuration.
         * </p>
         * 
         * @param message
         *        Returns an error message for the log delivery configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String logType;

        private String destinationType;

        private DestinationDetails destinationDetails;

        private String logFormat;

        private String status;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(LogDeliveryConfiguration model) {
            logType(model.logType);
            destinationType(model.destinationType);
            destinationDetails(model.destinationDetails);
            logFormat(model.logFormat);
            status(model.status);
            message(model.message);
        }

        public final String getLogType() {
            return logType;
        }

        @Override
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        public final String getDestinationType() {
            return destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final DestinationDetails.Builder getDestinationDetails() {
            return destinationDetails != null ? destinationDetails.toBuilder() : null;
        }

        @Override
        public final Builder destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public final void setDestinationDetails(DestinationDetails.BuilderImpl destinationDetails) {
            this.destinationDetails = destinationDetails != null ? destinationDetails.build() : null;
        }

        public final String getLogFormat() {
            return logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormat logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogDeliveryConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public LogDeliveryConfiguration build() {
            return new LogDeliveryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
