/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update action that has been processed for the corresponding apply/stop request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessedUpdateAction implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessedUpdateAction.Builder, ProcessedUpdateAction> {
    private static final SdkField<String> REPLICATION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationGroupId").getter(getter(ProcessedUpdateAction::replicationGroupId))
            .setter(setter(Builder::replicationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroupId").build())
            .build();

    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(ProcessedUpdateAction::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<String> SERVICE_UPDATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUpdateName").getter(getter(ProcessedUpdateAction::serviceUpdateName))
            .setter(setter(Builder::serviceUpdateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUpdateName").build()).build();

    private static final SdkField<String> UPDATE_ACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateActionStatus").getter(getter(ProcessedUpdateAction::updateActionStatusAsString))
            .setter(setter(Builder::updateActionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActionStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_ID_FIELD,
            CACHE_CLUSTER_ID_FIELD, SERVICE_UPDATE_NAME_FIELD, UPDATE_ACTION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationGroupId;

    private final String cacheClusterId;

    private final String serviceUpdateName;

    private final String updateActionStatus;

    private ProcessedUpdateAction(BuilderImpl builder) {
        this.replicationGroupId = builder.replicationGroupId;
        this.cacheClusterId = builder.cacheClusterId;
        this.serviceUpdateName = builder.serviceUpdateName;
        this.updateActionStatus = builder.updateActionStatus;
    }

    /**
     * <p>
     * The ID of the replication group
     * </p>
     * 
     * @return The ID of the replication group
     */
    public final String replicationGroupId() {
        return replicationGroupId;
    }

    /**
     * <p>
     * The ID of the cache cluster
     * </p>
     * 
     * @return The ID of the cache cluster
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * <p>
     * The unique ID of the service update
     * </p>
     * 
     * @return The unique ID of the service update
     */
    public final String serviceUpdateName() {
        return serviceUpdateName;
    }

    /**
     * <p>
     * The status of the update action on the Redis cluster
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateActionStatus} will return {@link UpdateActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateActionStatusAsString}.
     * </p>
     * 
     * @return The status of the update action on the Redis cluster
     * @see UpdateActionStatus
     */
    public final UpdateActionStatus updateActionStatus() {
        return UpdateActionStatus.fromValue(updateActionStatus);
    }

    /**
     * <p>
     * The status of the update action on the Redis cluster
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #updateActionStatus} will return {@link UpdateActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateActionStatusAsString}.
     * </p>
     * 
     * @return The status of the update action on the Redis cluster
     * @see UpdateActionStatus
     */
    public final String updateActionStatusAsString() {
        return updateActionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUpdateName());
        hashCode = 31 * hashCode + Objects.hashCode(updateActionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessedUpdateAction)) {
            return false;
        }
        ProcessedUpdateAction other = (ProcessedUpdateAction) obj;
        return Objects.equals(replicationGroupId(), other.replicationGroupId())
                && Objects.equals(cacheClusterId(), other.cacheClusterId())
                && Objects.equals(serviceUpdateName(), other.serviceUpdateName())
                && Objects.equals(updateActionStatusAsString(), other.updateActionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProcessedUpdateAction").add("ReplicationGroupId", replicationGroupId())
                .add("CacheClusterId", cacheClusterId()).add("ServiceUpdateName", serviceUpdateName())
                .add("UpdateActionStatus", updateActionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationGroupId":
            return Optional.ofNullable(clazz.cast(replicationGroupId()));
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "ServiceUpdateName":
            return Optional.ofNullable(clazz.cast(serviceUpdateName()));
        case "UpdateActionStatus":
            return Optional.ofNullable(clazz.cast(updateActionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessedUpdateAction, T> g) {
        return obj -> g.apply((ProcessedUpdateAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessedUpdateAction> {
        /**
         * <p>
         * The ID of the replication group
         * </p>
         * 
         * @param replicationGroupId
         *        The ID of the replication group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationGroupId(String replicationGroupId);

        /**
         * <p>
         * The ID of the cache cluster
         * </p>
         * 
         * @param cacheClusterId
         *        The ID of the cache cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * The unique ID of the service update
         * </p>
         * 
         * @param serviceUpdateName
         *        The unique ID of the service update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUpdateName(String serviceUpdateName);

        /**
         * <p>
         * The status of the update action on the Redis cluster
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action on the Redis cluster
         * @see UpdateActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionStatus
         */
        Builder updateActionStatus(String updateActionStatus);

        /**
         * <p>
         * The status of the update action on the Redis cluster
         * </p>
         * 
         * @param updateActionStatus
         *        The status of the update action on the Redis cluster
         * @see UpdateActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateActionStatus
         */
        Builder updateActionStatus(UpdateActionStatus updateActionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String replicationGroupId;

        private String cacheClusterId;

        private String serviceUpdateName;

        private String updateActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessedUpdateAction model) {
            replicationGroupId(model.replicationGroupId);
            cacheClusterId(model.cacheClusterId);
            serviceUpdateName(model.serviceUpdateName);
            updateActionStatus(model.updateActionStatus);
        }

        public final String getReplicationGroupId() {
            return replicationGroupId;
        }

        @Override
        public final Builder replicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
            return this;
        }

        public final void setReplicationGroupId(String replicationGroupId) {
            this.replicationGroupId = replicationGroupId;
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        public final String getServiceUpdateName() {
            return serviceUpdateName;
        }

        @Override
        public final Builder serviceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
            return this;
        }

        public final void setServiceUpdateName(String serviceUpdateName) {
            this.serviceUpdateName = serviceUpdateName;
        }

        public final String getUpdateActionStatus() {
            return updateActionStatus;
        }

        @Override
        public final Builder updateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
            return this;
        }

        @Override
        public final Builder updateActionStatus(UpdateActionStatus updateActionStatus) {
            this.updateActionStatus(updateActionStatus == null ? null : updateActionStatus.toString());
            return this;
        }

        public final void setUpdateActionStatus(String updateActionStatus) {
            this.updateActionStatus = updateActionStatus;
        }

        @Override
        public ProcessedUpdateAction build() {
            return new ProcessedUpdateAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
