/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticache.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>RebootCacheCluster</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebootCacheClusterRequest extends ElastiCacheRequest implements
        ToCopyableBuilder<RebootCacheClusterRequest.Builder, RebootCacheClusterRequest> {
    private static final SdkField<String> CACHE_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheClusterId").getter(getter(RebootCacheClusterRequest::cacheClusterId))
            .setter(setter(Builder::cacheClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterId").build()).build();

    private static final SdkField<List<String>> CACHE_NODE_IDS_TO_REBOOT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CacheNodeIdsToReboot")
            .getter(getter(RebootCacheClusterRequest::cacheNodeIdsToReboot))
            .setter(setter(Builder::cacheNodeIdsToReboot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheNodeIdsToReboot").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("CacheNodeId")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("CacheNodeId").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CLUSTER_ID_FIELD,
            CACHE_NODE_IDS_TO_REBOOT_FIELD));

    private final String cacheClusterId;

    private final List<String> cacheNodeIdsToReboot;

    private RebootCacheClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cacheClusterId = builder.cacheClusterId;
        this.cacheNodeIdsToReboot = builder.cacheNodeIdsToReboot;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is stored as a lowercase string.
     * </p>
     * 
     * @return The cluster identifier. This parameter is stored as a lowercase string.
     */
    public final String cacheClusterId() {
        return cacheClusterId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CacheNodeIdsToReboot property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCacheNodeIdsToReboot() {
        return cacheNodeIdsToReboot != null && !(cacheNodeIdsToReboot instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire
     * cluster, specify all of the cache node IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCacheNodeIdsToReboot} method.
     * </p>
     * 
     * @return A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an
     *         entire cluster, specify all of the cache node IDs.
     */
    public final List<String> cacheNodeIdsToReboot() {
        return cacheNodeIdsToReboot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCacheNodeIdsToReboot() ? cacheNodeIdsToReboot() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootCacheClusterRequest)) {
            return false;
        }
        RebootCacheClusterRequest other = (RebootCacheClusterRequest) obj;
        return Objects.equals(cacheClusterId(), other.cacheClusterId())
                && hasCacheNodeIdsToReboot() == other.hasCacheNodeIdsToReboot()
                && Objects.equals(cacheNodeIdsToReboot(), other.cacheNodeIdsToReboot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RebootCacheClusterRequest").add("CacheClusterId", cacheClusterId())
                .add("CacheNodeIdsToReboot", hasCacheNodeIdsToReboot() ? cacheNodeIdsToReboot() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheClusterId":
            return Optional.ofNullable(clazz.cast(cacheClusterId()));
        case "CacheNodeIdsToReboot":
            return Optional.ofNullable(clazz.cast(cacheNodeIdsToReboot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootCacheClusterRequest, T> g) {
        return obj -> g.apply((RebootCacheClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElastiCacheRequest.Builder, SdkPojo, CopyableBuilder<Builder, RebootCacheClusterRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is stored as a lowercase string.
         * </p>
         * 
         * @param cacheClusterId
         *        The cluster identifier. This parameter is stored as a lowercase string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheClusterId(String cacheClusterId);

        /**
         * <p>
         * A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire
         * cluster, specify all of the cache node IDs.
         * </p>
         * 
         * @param cacheNodeIdsToReboot
         *        A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an
         *        entire cluster, specify all of the cache node IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot);

        /**
         * <p>
         * A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire
         * cluster, specify all of the cache node IDs.
         * </p>
         * 
         * @param cacheNodeIdsToReboot
         *        A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an
         *        entire cluster, specify all of the cache node IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheNodeIdsToReboot(String... cacheNodeIdsToReboot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElastiCacheRequest.BuilderImpl implements Builder {
        private String cacheClusterId;

        private List<String> cacheNodeIdsToReboot = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RebootCacheClusterRequest model) {
            super(model);
            cacheClusterId(model.cacheClusterId);
            cacheNodeIdsToReboot(model.cacheNodeIdsToReboot);
        }

        public final String getCacheClusterId() {
            return cacheClusterId;
        }

        public final void setCacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
        }

        @Override
        public final Builder cacheClusterId(String cacheClusterId) {
            this.cacheClusterId = cacheClusterId;
            return this;
        }

        public final Collection<String> getCacheNodeIdsToReboot() {
            if (cacheNodeIdsToReboot instanceof SdkAutoConstructList) {
                return null;
            }
            return cacheNodeIdsToReboot;
        }

        public final void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
        }

        @Override
        public final Builder cacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
            this.cacheNodeIdsToReboot = CacheNodeIdsListCopier.copy(cacheNodeIdsToReboot);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cacheNodeIdsToReboot(String... cacheNodeIdsToReboot) {
            cacheNodeIdsToReboot(Arrays.asList(cacheNodeIdsToReboot));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootCacheClusterRequest build() {
            return new RebootCacheClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
