/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the Basic authorization parameters for the connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectionBasicAuthRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateConnectionBasicAuthRequestParameters.Builder, UpdateConnectionBasicAuthRequestParameters> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UpdateConnectionBasicAuthRequestParameters::username))
            .setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(UpdateConnectionBasicAuthRequestParameters::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(USERNAME_FIELD, PASSWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String username;

    private final String password;

    private UpdateConnectionBasicAuthRequestParameters(BuilderImpl builder) {
        this.username = builder.username;
        this.password = builder.password;
    }

    /**
     * <p>
     * The user name to use for Basic authorization.
     * </p>
     * 
     * @return The user name to use for Basic authorization.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The password associated with the user name to use for Basic authorization.
     * </p>
     * 
     * @return The password associated with the user name to use for Basic authorization.
     */
    public final String password() {
        return password;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionBasicAuthRequestParameters)) {
            return false;
        }
        UpdateConnectionBasicAuthRequestParameters other = (UpdateConnectionBasicAuthRequestParameters) obj;
        return Objects.equals(username(), other.username()) && Objects.equals(password(), other.password());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectionBasicAuthRequestParameters").add("Username", username())
                .add("Password", password()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionBasicAuthRequestParameters, T> g) {
        return obj -> g.apply((UpdateConnectionBasicAuthRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateConnectionBasicAuthRequestParameters> {
        /**
         * <p>
         * The user name to use for Basic authorization.
         * </p>
         * 
         * @param username
         *        The user name to use for Basic authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The password associated with the user name to use for Basic authorization.
         * </p>
         * 
         * @param password
         *        The password associated with the user name to use for Basic authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);
    }

    static final class BuilderImpl implements Builder {
        private String username;

        private String password;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionBasicAuthRequestParameters model) {
            username(model.username);
            password(model.password);
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        @Override
        public UpdateConnectionBasicAuthRequestParameters build() {
            return new UpdateConnectionBasicAuthRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
