/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGameSessionDetailsRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribeGameSessionDetailsRequest.Builder, DescribeGameSessionDetailsRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(DescribeGameSessionDetailsRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(DescribeGameSessionDetailsRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(DescribeGameSessionDetailsRequest::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(DescribeGameSessionDetailsRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilter").getter(getter(DescribeGameSessionDetailsRequest::statusFilter))
            .setter(setter(Builder::statusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeGameSessionDetailsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeGameSessionDetailsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            GAME_SESSION_ID_FIELD, ALIAS_ID_FIELD, LOCATION_FIELD, STATUS_FILTER_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String fleetId;

    private final String gameSessionId;

    private final String aliasId;

    private final String location;

    private final String statusFilter;

    private final Integer limit;

    private final String nextToken;

    private DescribeGameSessionDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.gameSessionId = builder.gameSessionId;
        this.aliasId = builder.aliasId;
        this.location = builder.location;
        this.statusFilter = builder.statusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the fleet
     * ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either
     *         the fleet ID or ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for the game session to retrieve.
     * </p>
     * 
     * @return A unique identifier for the game session to retrieve.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use either
     * the alias ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can
     *         use either the alias ID or ARN value.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location. Use the
     * Amazon Web Services Region code format, such as <code>us-west-2</code>.
     * </p>
     * 
     * @return A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location.
     *         Use the Amazon Web Services Region code format, such as <code>us-west-2</code>.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>,
     * <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory).
     * </p>
     * 
     * @return Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>,
     *         <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are
     *         transitory).
     */
    public final String statusFilter() {
        return statusFilter;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionDetailsRequest)) {
            return false;
        }
        DescribeGameSessionDetailsRequest other = (DescribeGameSessionDetailsRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(gameSessionId(), other.gameSessionId())
                && Objects.equals(aliasId(), other.aliasId()) && Objects.equals(location(), other.location())
                && Objects.equals(statusFilter(), other.statusFilter()) && Objects.equals(limit(), other.limit())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGameSessionDetailsRequest").add("FleetId", fleetId())
                .add("GameSessionId", gameSessionId()).add("AliasId", aliasId()).add("Location", location())
                .add("StatusFilter", statusFilter()).add("Limit", limit()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "StatusFilter":
            return Optional.ofNullable(clazz.cast(statusFilter()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionDetailsRequest, T> g) {
        return obj -> g.apply((DescribeGameSessionDetailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGameSessionDetailsRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use either the
         * fleet ID or ARN value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to retrieve all game sessions active on the fleet. You can use
         *        either the fleet ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for the game session to retrieve.
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can use
         * either the alias ID or ARN value.
         * </p>
         * 
         * @param aliasId
         *        A unique identifier for the alias associated with the fleet to retrieve all game sessions for. You can
         *        use either the alias ID or ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location. Use
         * the Amazon Web Services Region code format, such as <code>us-west-2</code>.
         * </p>
         * 
         * @param location
         *        A fleet location to get game sessions for. You can specify a fleet's home Region or a remote location.
         *        Use the Amazon Web Services Region code format, such as <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>,
         * <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are transitory).
         * </p>
         * 
         * @param statusFilter
         *        Game session status to filter results on. Possible game session statuses include <code>ACTIVE</code>,
         *        <code>TERMINATED</code>, <code>ACTIVATING</code> and <code>TERMINATING</code> (the last two are
         *        transitory).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusFilter(String statusFilter);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String gameSessionId;

        private String aliasId;

        private String location;

        private String statusFilter;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionDetailsRequest model) {
            super(model);
            fleetId(model.fleetId);
            gameSessionId(model.gameSessionId);
            aliasId(model.aliasId);
            location(model.location);
            statusFilter(model.statusFilter);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getAliasId() {
            return aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getStatusFilter() {
            return statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGameSessionDetailsRequest build() {
            return new DescribeGameSessionDetailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
