/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePlayerSessionsRequest extends GameLiftRequest implements
        ToCopyableBuilder<DescribePlayerSessionsRequest.Builder, DescribePlayerSessionsRequest> {
    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(DescribePlayerSessionsRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> PLAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerId").getter(getter(DescribePlayerSessionsRequest::playerId)).setter(setter(Builder::playerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerId").build()).build();

    private static final SdkField<String> PLAYER_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerSessionId").getter(getter(DescribePlayerSessionsRequest::playerSessionId))
            .setter(setter(Builder::playerSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionId").build()).build();

    private static final SdkField<String> PLAYER_SESSION_STATUS_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlayerSessionStatusFilter").getter(getter(DescribePlayerSessionsRequest::playerSessionStatusFilter))
            .setter(setter(Builder::playerSessionStatusFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerSessionStatusFilter").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribePlayerSessionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePlayerSessionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_ID_FIELD,
            PLAYER_ID_FIELD, PLAYER_SESSION_ID_FIELD, PLAYER_SESSION_STATUS_FILTER_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));

    private final String gameSessionId;

    private final String playerId;

    private final String playerSessionId;

    private final String playerSessionStatusFilter;

    private final Integer limit;

    private final String nextToken;

    private DescribePlayerSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.gameSessionId = builder.gameSessionId;
        this.playerId = builder.playerId;
        this.playerSessionId = builder.playerSessionId;
        this.playerSessionStatusFilter = builder.playerSessionStatusFilter;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A unique identifier for the game session to retrieve player sessions for.
     * </p>
     * 
     * @return A unique identifier for the game session to retrieve player sessions for.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * A unique identifier for a player to retrieve player sessions for.
     * </p>
     * 
     * @return A unique identifier for a player to retrieve player sessions for.
     */
    public final String playerId() {
        return playerId;
    }

    /**
     * <p>
     * A unique identifier for a player session to retrieve.
     * </p>
     * 
     * @return A unique identifier for a player session to retrieve.
     */
    public final String playerSessionId() {
        return playerSessionId;
    }

    /**
     * <p>
     * Player session status to filter results on.
     * </p>
     * <p>
     * Possible player session statuses include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the
     * server process and/or been validated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPLETED</b> -- The player connection has been dropped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not validated
     * within the timeout limit (60 seconds).
     * </p>
     * </li>
     * </ul>
     * 
     * @return Player session status to filter results on.</p>
     *         <p>
     *         Possible player session statuses include the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to
     *         the server process and/or been validated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>COMPLETED</b> -- The player connection has been dropped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not
     *         validated within the timeout limit (60 seconds).
     *         </p>
     *         </li>
     */
    public final String playerSessionStatusFilter() {
        return playerSessionStatusFilter;
    }

    /**
     * <p>
     * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a set
     * of sequential pages. If a player session ID is specified, this parameter is ignored.
     * </p>
     * 
     * @return The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as
     *         a set of sequential pages. If a player session ID is specified, this parameter is ignored.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A token that indicates the start of the next sequential page of results. Use the token that is returned with a
     * previous call to this operation. To start at the beginning of the result set, do not specify a value. If a player
     * session ID is specified, this parameter is ignored.
     * </p>
     * 
     * @return A token that indicates the start of the next sequential page of results. Use the token that is returned
     *         with a previous call to this operation. To start at the beginning of the result set, do not specify a
     *         value. If a player session ID is specified, this parameter is ignored.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(playerId());
        hashCode = 31 * hashCode + Objects.hashCode(playerSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(playerSessionStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePlayerSessionsRequest)) {
            return false;
        }
        DescribePlayerSessionsRequest other = (DescribePlayerSessionsRequest) obj;
        return Objects.equals(gameSessionId(), other.gameSessionId()) && Objects.equals(playerId(), other.playerId())
                && Objects.equals(playerSessionId(), other.playerSessionId())
                && Objects.equals(playerSessionStatusFilter(), other.playerSessionStatusFilter())
                && Objects.equals(limit(), other.limit()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePlayerSessionsRequest").add("GameSessionId", gameSessionId())
                .add("PlayerId", playerId()).add("PlayerSessionId", playerSessionId())
                .add("PlayerSessionStatusFilter", playerSessionStatusFilter()).add("Limit", limit())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "PlayerId":
            return Optional.ofNullable(clazz.cast(playerId()));
        case "PlayerSessionId":
            return Optional.ofNullable(clazz.cast(playerSessionId()));
        case "PlayerSessionStatusFilter":
            return Optional.ofNullable(clazz.cast(playerSessionStatusFilter()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePlayerSessionsRequest, T> g) {
        return obj -> g.apply((DescribePlayerSessionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribePlayerSessionsRequest> {
        /**
         * <p>
         * A unique identifier for the game session to retrieve player sessions for.
         * </p>
         * 
         * @param gameSessionId
         *        A unique identifier for the game session to retrieve player sessions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * A unique identifier for a player to retrieve player sessions for.
         * </p>
         * 
         * @param playerId
         *        A unique identifier for a player to retrieve player sessions for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerId(String playerId);

        /**
         * <p>
         * A unique identifier for a player session to retrieve.
         * </p>
         * 
         * @param playerSessionId
         *        A unique identifier for a player session to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerSessionId(String playerSessionId);

        /**
         * <p>
         * Player session status to filter results on.
         * </p>
         * <p>
         * Possible player session statuses include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected to the
         * server process and/or been validated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>COMPLETED</b> -- The player connection has been dropped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was not
         * validated within the timeout limit (60 seconds).
         * </p>
         * </li>
         * </ul>
         * 
         * @param playerSessionStatusFilter
         *        Player session status to filter results on.</p>
         *        <p>
         *        Possible player session statuses include the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>RESERVED</b> -- The player session request has been received, but the player has not yet connected
         *        to the server process and/or been validated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b> -- The player has been validated by the server process and is currently connected.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>COMPLETED</b> -- The player connection has been dropped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TIMEDOUT</b> -- A player session request was received, but the player did not connect and/or was
         *        not validated within the timeout limit (60 seconds).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerSessionStatusFilter(String playerSessionStatusFilter);

        /**
         * <p>
         * The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results as a
         * set of sequential pages. If a player session ID is specified, this parameter is ignored.
         * </p>
         * 
         * @param limit
         *        The maximum number of results to return. Use this parameter with <code>NextToken</code> to get results
         *        as a set of sequential pages. If a player session ID is specified, this parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A token that indicates the start of the next sequential page of results. Use the token that is returned with
         * a previous call to this operation. To start at the beginning of the result set, do not specify a value. If a
         * player session ID is specified, this parameter is ignored.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the start of the next sequential page of results. Use the token that is
         *        returned with a previous call to this operation. To start at the beginning of the result set, do not
         *        specify a value. If a player session ID is specified, this parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameSessionId;

        private String playerId;

        private String playerSessionId;

        private String playerSessionStatusFilter;

        private Integer limit;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePlayerSessionsRequest model) {
            super(model);
            gameSessionId(model.gameSessionId);
            playerId(model.playerId);
            playerSessionId(model.playerSessionId);
            playerSessionStatusFilter(model.playerSessionStatusFilter);
            limit(model.limit);
            nextToken(model.nextToken);
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getPlayerId() {
            return playerId;
        }

        public final void setPlayerId(String playerId) {
            this.playerId = playerId;
        }

        @Override
        public final Builder playerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public final String getPlayerSessionId() {
            return playerSessionId;
        }

        public final void setPlayerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
        }

        @Override
        public final Builder playerSessionId(String playerSessionId) {
            this.playerSessionId = playerSessionId;
            return this;
        }

        public final String getPlayerSessionStatusFilter() {
            return playerSessionStatusFilter;
        }

        public final void setPlayerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
        }

        @Override
        public final Builder playerSessionStatusFilter(String playerSessionStatusFilter) {
            this.playerSessionStatusFilter = playerSessionStatusFilter;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribePlayerSessionsRequest build() {
            return new DescribePlayerSessionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
