/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResumeGameServerGroupRequest extends GameLiftRequest implements
        ToCopyableBuilder<ResumeGameServerGroupRequest.Builder, ResumeGameServerGroupRequest> {
    private static final SdkField<String> GAME_SERVER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameServerGroupName").getter(getter(ResumeGameServerGroupRequest::gameServerGroupName))
            .setter(setter(Builder::gameServerGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameServerGroupName").build())
            .build();

    private static final SdkField<List<String>> RESUME_ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResumeActions")
            .getter(getter(ResumeGameServerGroupRequest::resumeActionsAsStrings))
            .setter(setter(Builder::resumeActionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SERVER_GROUP_NAME_FIELD,
            RESUME_ACTIONS_FIELD));

    private final String gameServerGroupName;

    private final List<String> resumeActions;

    private ResumeGameServerGroupRequest(BuilderImpl builder) {
        super(builder);
        this.gameServerGroupName = builder.gameServerGroupName;
        this.resumeActions = builder.resumeActions;
    }

    /**
     * <p>
     * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     * </p>
     * 
     * @return A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
     */
    public final String gameServerGroupName() {
        return gameServerGroupName;
    }

    /**
     * <p>
     * The activity to resume for this game server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResumeActions} method.
     * </p>
     * 
     * @return The activity to resume for this game server group.
     */
    public final List<GameServerGroupAction> resumeActions() {
        return GameServerGroupActionsCopier.copyStringToEnum(resumeActions);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResumeActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResumeActions() {
        return resumeActions != null && !(resumeActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The activity to resume for this game server group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResumeActions} method.
     * </p>
     * 
     * @return The activity to resume for this game server group.
     */
    public final List<String> resumeActionsAsStrings() {
        return resumeActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameServerGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResumeActions() ? resumeActionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeGameServerGroupRequest)) {
            return false;
        }
        ResumeGameServerGroupRequest other = (ResumeGameServerGroupRequest) obj;
        return Objects.equals(gameServerGroupName(), other.gameServerGroupName())
                && hasResumeActions() == other.hasResumeActions()
                && Objects.equals(resumeActionsAsStrings(), other.resumeActionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResumeGameServerGroupRequest").add("GameServerGroupName", gameServerGroupName())
                .add("ResumeActions", hasResumeActions() ? resumeActionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameServerGroupName":
            return Optional.ofNullable(clazz.cast(gameServerGroupName()));
        case "ResumeActions":
            return Optional.ofNullable(clazz.cast(resumeActionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeGameServerGroupRequest, T> g) {
        return obj -> g.apply((ResumeGameServerGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ResumeGameServerGroupRequest> {
        /**
         * <p>
         * A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN value.
         * </p>
         * 
         * @param gameServerGroupName
         *        A unique identifier for the game server group. Use either the <a>GameServerGroup</a> name or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameServerGroupName(String gameServerGroupName);

        /**
         * <p>
         * The activity to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The activity to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActionsWithStrings(Collection<String> resumeActions);

        /**
         * <p>
         * The activity to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The activity to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActionsWithStrings(String... resumeActions);

        /**
         * <p>
         * The activity to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The activity to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActions(Collection<GameServerGroupAction> resumeActions);

        /**
         * <p>
         * The activity to resume for this game server group.
         * </p>
         * 
         * @param resumeActions
         *        The activity to resume for this game server group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeActions(GameServerGroupAction... resumeActions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String gameServerGroupName;

        private List<String> resumeActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeGameServerGroupRequest model) {
            super(model);
            gameServerGroupName(model.gameServerGroupName);
            resumeActionsWithStrings(model.resumeActions);
        }

        public final String getGameServerGroupName() {
            return gameServerGroupName;
        }

        public final void setGameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
        }

        @Override
        public final Builder gameServerGroupName(String gameServerGroupName) {
            this.gameServerGroupName = gameServerGroupName;
            return this;
        }

        public final Collection<String> getResumeActions() {
            if (resumeActions instanceof SdkAutoConstructList) {
                return null;
            }
            return resumeActions;
        }

        public final void setResumeActions(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
        }

        @Override
        public final Builder resumeActionsWithStrings(Collection<String> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copy(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActionsWithStrings(String... resumeActions) {
            resumeActionsWithStrings(Arrays.asList(resumeActions));
            return this;
        }

        @Override
        public final Builder resumeActions(Collection<GameServerGroupAction> resumeActions) {
            this.resumeActions = GameServerGroupActionsCopier.copyEnumToString(resumeActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resumeActions(GameServerGroupAction... resumeActions) {
            resumeActions(Arrays.asList(resumeActions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeGameServerGroupRequest build() {
            return new ResumeGameServerGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
