/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetDevEndpointsResponse extends GlueResponse implements
        ToCopyableBuilder<BatchGetDevEndpointsResponse.Builder, BatchGetDevEndpointsResponse> {
    private static final SdkField<List<DevEndpoint>> DEV_ENDPOINTS_FIELD = SdkField
            .<List<DevEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDevEndpointsResponse::devEndpoints))
            .setter(setter(Builder::devEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DevEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(DevEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEV_ENDPOINTS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetDevEndpointsResponse::devEndpointsNotFound))
            .setter(setter(Builder::devEndpointsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINTS_FIELD,
            DEV_ENDPOINTS_NOT_FOUND_FIELD));

    private final List<DevEndpoint> devEndpoints;

    private final List<String> devEndpointsNotFound;

    private BatchGetDevEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.devEndpoints = builder.devEndpoints;
        this.devEndpointsNotFound = builder.devEndpointsNotFound;
    }

    /**
     * Returns true if the DevEndpoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDevEndpoints() {
        return devEndpoints != null && !(devEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DevEndpoint</code> definitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevEndpoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>DevEndpoint</code> definitions.
     */
    public List<DevEndpoint> devEndpoints() {
        return devEndpoints;
    }

    /**
     * Returns true if the DevEndpointsNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDevEndpointsNotFound() {
        return devEndpointsNotFound != null && !(devEndpointsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DevEndpoints</code> not found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevEndpointsNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>DevEndpoints</code> not found.
     */
    public List<String> devEndpointsNotFound() {
        return devEndpointsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(devEndpoints());
        hashCode = 31 * hashCode + Objects.hashCode(devEndpointsNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevEndpointsResponse)) {
            return false;
        }
        BatchGetDevEndpointsResponse other = (BatchGetDevEndpointsResponse) obj;
        return Objects.equals(devEndpoints(), other.devEndpoints())
                && Objects.equals(devEndpointsNotFound(), other.devEndpointsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetDevEndpointsResponse").add("DevEndpoints", devEndpoints())
                .add("DevEndpointsNotFound", devEndpointsNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevEndpoints":
            return Optional.ofNullable(clazz.cast(devEndpoints()));
        case "DevEndpointsNotFound":
            return Optional.ofNullable(clazz.cast(devEndpointsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevEndpointsResponse, T> g) {
        return obj -> g.apply((BatchGetDevEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetDevEndpointsResponse> {
        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * 
         * @param devEndpoints
         *        A list of <code>DevEndpoint</code> definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpoints(Collection<DevEndpoint> devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * 
         * @param devEndpoints
         *        A list of <code>DevEndpoint</code> definitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpoints(DevEndpoint... devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoint</code> definitions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DevEndpoint>.Builder} avoiding the need to
         * create one manually via {@link List<DevEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DevEndpoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #devEndpoints(List<DevEndpoint>)}.
         * 
         * @param devEndpoints
         *        a consumer that will call methods on {@link List<DevEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devEndpoints(List<DevEndpoint>)
         */
        Builder devEndpoints(Consumer<DevEndpoint.Builder>... devEndpoints);

        /**
         * <p>
         * A list of <code>DevEndpoints</code> not found.
         * </p>
         * 
         * @param devEndpointsNotFound
         *        A list of <code>DevEndpoints</code> not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointsNotFound(Collection<String> devEndpointsNotFound);

        /**
         * <p>
         * A list of <code>DevEndpoints</code> not found.
         * </p>
         * 
         * @param devEndpointsNotFound
         *        A list of <code>DevEndpoints</code> not found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devEndpointsNotFound(String... devEndpointsNotFound);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<DevEndpoint> devEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<String> devEndpointsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevEndpointsResponse model) {
            super(model);
            devEndpoints(model.devEndpoints);
            devEndpointsNotFound(model.devEndpointsNotFound);
        }

        public final Collection<DevEndpoint.Builder> getDevEndpoints() {
            return devEndpoints != null ? devEndpoints.stream().map(DevEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devEndpoints(Collection<DevEndpoint> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copy(devEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(DevEndpoint... devEndpoints) {
            devEndpoints(Arrays.asList(devEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpoints(Consumer<DevEndpoint.Builder>... devEndpoints) {
            devEndpoints(Stream.of(devEndpoints).map(c -> DevEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDevEndpoints(Collection<DevEndpoint.BuilderImpl> devEndpoints) {
            this.devEndpoints = DevEndpointListCopier.copyFromBuilder(devEndpoints);
        }

        public final Collection<String> getDevEndpointsNotFound() {
            return devEndpointsNotFound;
        }

        @Override
        public final Builder devEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointsNotFound(String... devEndpointsNotFound) {
            devEndpointsNotFound(Arrays.asList(devEndpointsNotFound));
            return this;
        }

        public final void setDevEndpointsNotFound(Collection<String> devEndpointsNotFound) {
            this.devEndpointsNotFound = DevEndpointNamesCopier.copy(devEndpointsNotFound);
        }

        @Override
        public BatchGetDevEndpointsResponse build() {
            return new BatchGetDevEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
