/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that is used to specify a connection to create or update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionInput implements SdkPojo, Serializable, ToCopyableBuilder<ConnectionInput.Builder, ConnectionInput> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ConnectionInput::connectionTypeAsString)).setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ConnectionInput::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ConnectionInput::connectionPropertiesAsStrings))
            .setter(setter(Builder::connectionPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .getter(getter(ConnectionInput::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalConnectionRequirements")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CONNECTION_TYPE_FIELD, MATCH_CRITERIA_FIELD, CONNECTION_PROPERTIES_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String connectionType;

    private final List<String> matchCriteria;

    private final Map<String, String> connectionProperties;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private ConnectionInput(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.connectionType = builder.connectionType;
        this.matchCriteria = builder.matchCriteria;
        this.connectionProperties = builder.connectionProperties;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the connection.
     * </p>
     * 
     * @return The description of the connection.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
     * @see ConnectionType
     */
    public ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
     * @see ConnectionType
     */
    public String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * Returns true if the MatchCriteria property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of criteria that can be used in selecting this connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchCriteria()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of criteria that can be used in selecting this connection.
     */
    public List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public Map<ConnectionPropertyKey, String> connectionProperties() {
        return ConnectionPropertiesCopier.copyStringToEnum(connectionProperties);
    }

    /**
     * Returns true if the ConnectionProperties property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * These key-value pairs define parameters for the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConnectionProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return These key-value pairs define parameters for the connection.
     */
    public Map<String, String> connectionPropertiesAsStrings() {
        return connectionProperties;
    }

    /**
     * <p>
     * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>,
     * that are needed to successfully make this connection.
     * </p>
     * 
     * @return A map of physical connection requirements, such as virtual private cloud (VPC) and
     *         <code>SecurityGroup</code>, that are needed to successfully make this connection.
     */
    public PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(connectionPropertiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionInput)) {
            return false;
        }
        ConnectionInput other = (ConnectionInput) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(matchCriteria(), other.matchCriteria())
                && Objects.equals(connectionPropertiesAsStrings(), other.connectionPropertiesAsStrings())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ConnectionInput").add("Name", name()).add("Description", description())
                .add("ConnectionType", connectionTypeAsString()).add("MatchCriteria", matchCriteria())
                .add("ConnectionProperties", connectionPropertiesAsStrings())
                .add("PhysicalConnectionRequirements", physicalConnectionRequirements()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionProperties":
            return Optional.ofNullable(clazz.cast(connectionPropertiesAsStrings()));
        case "PhysicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionInput, T> g) {
        return obj -> g.apply((ConnectionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionInput> {
        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param name
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the connection.
         * </p>
         * 
         * @param description
         *        The description of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of the connection. Currently, only JDBC is supported; SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A list of criteria that can be used in selecting this connection.
         * </p>
         * 
         * @param matchCriteria
         *        A list of criteria that can be used in selecting this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties);

        /**
         * <p>
         * These key-value pairs define parameters for the connection.
         * </p>
         * 
         * @param connectionProperties
         *        These key-value pairs define parameters for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties);

        /**
         * <p>
         * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>
         * , that are needed to successfully make this connection.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        A map of physical connection requirements, such as virtual private cloud (VPC) and
         *        <code>SecurityGroup</code>, that are needed to successfully make this connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * A map of physical connection requirements, such as virtual private cloud (VPC) and <code>SecurityGroup</code>
         * , that are needed to successfully make this connection.
         * </p>
         * This is a convenience that creates an instance of the {@link PhysicalConnectionRequirements.Builder} avoiding
         * the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String connectionType;

        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionInput model) {
            name(model.name);
            description(model.description);
            connectionType(model.connectionType);
            matchCriteria(model.matchCriteria);
            connectionPropertiesWithStrings(model.connectionProperties);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getConnectionTypeAsString() {
            return connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        public final Collection<String> getMatchCriteria() {
            return matchCriteria;
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        public final Map<String, String> getConnectionPropertiesAsStrings() {
            return connectionProperties;
        }

        @Override
        public final Builder connectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        @Override
        public final Builder connectionProperties(Map<ConnectionPropertyKey, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copyEnumToString(connectionProperties);
            return this;
        }

        public final void setConnectionPropertiesWithStrings(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        public ConnectionInput build() {
            return new ConnectionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
