/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filters the connection definitions that are returned by the <code>GetConnections</code> API operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionsFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GetConnectionsFilter.Builder, GetConnectionsFilter> {
    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetConnectionsFilter::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetConnectionsFilter::connectionTypeAsString)).setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_CRITERIA_FIELD,
            CONNECTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> matchCriteria;

    private final String connectionType;

    private GetConnectionsFilter(BuilderImpl builder) {
        this.matchCriteria = builder.matchCriteria;
        this.connectionType = builder.connectionType;
    }

    /**
     * Returns true if the MatchCriteria property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A criteria string that must match the criteria recorded in the connection definition for that connection
     * definition to be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchCriteria()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A criteria string that must match the criteria recorded in the connection definition for that connection
     *         definition to be returned.
     */
    public List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
     * @see ConnectionType
     */
    public ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
     * @see ConnectionType
     */
    public String connectionTypeAsString() {
        return connectionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionsFilter)) {
            return false;
        }
        GetConnectionsFilter other = (GetConnectionsFilter) obj;
        return Objects.equals(matchCriteria(), other.matchCriteria())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetConnectionsFilter").add("MatchCriteria", matchCriteria())
                .add("ConnectionType", connectionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "ConnectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionsFilter, T> g) {
        return obj -> g.apply((GetConnectionsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetConnectionsFilter> {
        /**
         * <p>
         * A criteria string that must match the criteria recorded in the connection definition for that connection
         * definition to be returned.
         * </p>
         * 
         * @param matchCriteria
         *        A criteria string that must match the criteria recorded in the connection definition for that
         *        connection definition to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * A criteria string that must match the criteria recorded in the connection definition for that connection
         * definition to be returned.
         * </p>
         * 
         * @param matchCriteria
         *        A criteria string that must match the criteria recorded in the connection definition for that
         *        connection definition to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
         * </p>
         * 
         * @param connectionType
         *        The type of connections to return. Currently, only JDBC is supported; SFTP is not supported.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private String connectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionsFilter model) {
            matchCriteria(model.matchCriteria);
            connectionType(model.connectionType);
        }

        public final Collection<String> getMatchCriteria() {
            return matchCriteria;
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        public final String getConnectionTypeAsString() {
            return connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public GetConnectionsFilter build() {
            return new GetConnectionsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
