/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlanRequest extends GlueRequest implements ToCopyableBuilder<GetPlanRequest.Builder, GetPlanRequest> {
    private static final SdkField<List<MappingEntry>> MAPPING_FIELD = SdkField
            .<List<MappingEntry>> builder(MarshallingType.LIST)
            .getter(getter(GetPlanRequest::mapping))
            .setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mapping").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MappingEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(MappingEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CatalogEntry> SOURCE_FIELD = SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetPlanRequest::source)).setter(setter(Builder::source)).constructor(CatalogEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<CatalogEntry>> SINKS_FIELD = SdkField
            .<List<CatalogEntry>> builder(MarshallingType.LIST)
            .getter(getter(GetPlanRequest::sinks))
            .setter(setter(Builder::sinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CatalogEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(CatalogEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Location> LOCATION_FIELD = SdkField.<Location> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetPlanRequest::location)).setter(setter(Builder::location)).constructor(Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetPlanRequest::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPING_FIELD, SOURCE_FIELD,
            SINKS_FIELD, LOCATION_FIELD, LANGUAGE_FIELD));

    private final List<MappingEntry> mapping;

    private final CatalogEntry source;

    private final List<CatalogEntry> sinks;

    private final Location location;

    private final String language;

    private GetPlanRequest(BuilderImpl builder) {
        super(builder);
        this.mapping = builder.mapping;
        this.source = builder.source;
        this.sinks = builder.sinks;
        this.location = builder.location;
        this.language = builder.language;
    }

    /**
     * Returns true if the Mapping property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMapping() {
        return mapping != null && !(mapping instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of mappings from a source table to target tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMapping()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of mappings from a source table to target tables.
     */
    public List<MappingEntry> mapping() {
        return mapping;
    }

    /**
     * <p>
     * The source table.
     * </p>
     * 
     * @return The source table.
     */
    public CatalogEntry source() {
        return source;
    }

    /**
     * Returns true if the Sinks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSinks() {
        return sinks != null && !(sinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSinks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The target tables.
     */
    public List<CatalogEntry> sinks() {
        return sinks;
    }

    /**
     * <p>
     * The parameters for the mapping.
     * </p>
     * 
     * @return The parameters for the mapping.
     */
    public Location location() {
        return location;
    }

    /**
     * <p>
     * The programming language of the code to perform the mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to perform the mapping.
     * @see Language
     */
    public Language language() {
        return Language.fromValue(language);
    }

    /**
     * <p>
     * The programming language of the code to perform the mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link Language#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language of the code to perform the mapping.
     * @see Language
     */
    public String languageAsString() {
        return language;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mapping());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sinks());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanRequest)) {
            return false;
        }
        GetPlanRequest other = (GetPlanRequest) obj;
        return Objects.equals(mapping(), other.mapping()) && Objects.equals(source(), other.source())
                && Objects.equals(sinks(), other.sinks()) && Objects.equals(location(), other.location())
                && Objects.equals(languageAsString(), other.languageAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPlanRequest").add("Mapping", mapping()).add("Source", source()).add("Sinks", sinks())
                .add("Location", location()).add("Language", languageAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mapping()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Sinks":
            return Optional.ofNullable(clazz.cast(sinks()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "Language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPlanRequest, T> g) {
        return obj -> g.apply((GetPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPlanRequest> {
        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * 
         * @param mapping
         *        The list of mappings from a source table to target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(Collection<MappingEntry> mapping);

        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * 
         * @param mapping
         *        The list of mappings from a source table to target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapping(MappingEntry... mapping);

        /**
         * <p>
         * The list of mappings from a source table to target tables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MappingEntry>.Builder} avoiding the need to
         * create one manually via {@link List<MappingEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MappingEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #mapping(List<MappingEntry>)}.
         * 
         * @param mapping
         *        a consumer that will call methods on {@link List<MappingEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mapping(List<MappingEntry>)
         */
        Builder mapping(Consumer<MappingEntry.Builder>... mapping);

        /**
         * <p>
         * The source table.
         * </p>
         * 
         * @param source
         *        The source table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(CatalogEntry source);

        /**
         * <p>
         * The source table.
         * </p>
         * This is a convenience that creates an instance of the {@link CatalogEntry.Builder} avoiding the need to
         * create one manually via {@link CatalogEntry#builder()}.
         *
         * When the {@link Consumer} completes, {@link CatalogEntry.Builder#build()} is called immediately and its
         * result is passed to {@link #source(CatalogEntry)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link CatalogEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(CatalogEntry)
         */
        default Builder source(Consumer<CatalogEntry.Builder> source) {
            return source(CatalogEntry.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The target tables.
         * </p>
         * 
         * @param sinks
         *        The target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(Collection<CatalogEntry> sinks);

        /**
         * <p>
         * The target tables.
         * </p>
         * 
         * @param sinks
         *        The target tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sinks(CatalogEntry... sinks);

        /**
         * <p>
         * The target tables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CatalogEntry>.Builder} avoiding the need to
         * create one manually via {@link List<CatalogEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CatalogEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #sinks(List<CatalogEntry>)}.
         * 
         * @param sinks
         *        a consumer that will call methods on {@link List<CatalogEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sinks(List<CatalogEntry>)
         */
        Builder sinks(Consumer<CatalogEntry.Builder>... sinks);

        /**
         * <p>
         * The parameters for the mapping.
         * </p>
         * 
         * @param location
         *        The parameters for the mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(Location location);

        /**
         * <p>
         * The parameters for the mapping.
         * </p>
         * This is a convenience that creates an instance of the {@link Location.Builder} avoiding the need to create
         * one manually via {@link Location#builder()}.
         *
         * When the {@link Consumer} completes, {@link Location.Builder#build()} is called immediately and its result is
         * passed to {@link #location(Location)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(Location)
         */
        default Builder location(Consumer<Location.Builder> location) {
            return location(Location.builder().applyMutation(location).build());
        }

        /**
         * <p>
         * The programming language of the code to perform the mapping.
         * </p>
         * 
         * @param language
         *        The programming language of the code to perform the mapping.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(String language);

        /**
         * <p>
         * The programming language of the code to perform the mapping.
         * </p>
         * 
         * @param language
         *        The programming language of the code to perform the mapping.
         * @see Language
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Language
         */
        Builder language(Language language);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private List<MappingEntry> mapping = DefaultSdkAutoConstructList.getInstance();

        private CatalogEntry source;

        private List<CatalogEntry> sinks = DefaultSdkAutoConstructList.getInstance();

        private Location location;

        private String language;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanRequest model) {
            super(model);
            mapping(model.mapping);
            source(model.source);
            sinks(model.sinks);
            location(model.location);
            language(model.language);
        }

        public final Collection<MappingEntry.Builder> getMapping() {
            return mapping != null ? mapping.stream().map(MappingEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mapping(Collection<MappingEntry> mapping) {
            this.mapping = MappingListCopier.copy(mapping);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(MappingEntry... mapping) {
            mapping(Arrays.asList(mapping));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapping(Consumer<MappingEntry.Builder>... mapping) {
            mapping(Stream.of(mapping).map(c -> MappingEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMapping(Collection<MappingEntry.BuilderImpl> mapping) {
            this.mapping = MappingListCopier.copyFromBuilder(mapping);
        }

        public final CatalogEntry.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(CatalogEntry source) {
            this.source = source;
            return this;
        }

        public final void setSource(CatalogEntry.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<CatalogEntry.Builder> getSinks() {
            return sinks != null ? sinks.stream().map(CatalogEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sinks(Collection<CatalogEntry> sinks) {
            this.sinks = CatalogEntriesCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(CatalogEntry... sinks) {
            sinks(Arrays.asList(sinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(Consumer<CatalogEntry.Builder>... sinks) {
            sinks(Stream.of(sinks).map(c -> CatalogEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSinks(Collection<CatalogEntry.BuilderImpl> sinks) {
            this.sinks = CatalogEntriesCopier.copyFromBuilder(sinks);
        }

        public final Location.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getLanguageAsString() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(Language language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPlanRequest build() {
            return new GetPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
