/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a partition error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PartitionError implements SdkPojo, Serializable, ToCopyableBuilder<PartitionError.Builder, PartitionError> {
    private static final SdkField<List<String>> PARTITION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PartitionError::partitionValues))
            .setter(setter(Builder::partitionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ErrorDetail> ERROR_DETAIL_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .getter(getter(PartitionError::errorDetail)).setter(setter(Builder::errorDetail)).constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTITION_VALUES_FIELD,
            ERROR_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> partitionValues;

    private final ErrorDetail errorDetail;

    private PartitionError(BuilderImpl builder) {
        this.partitionValues = builder.partitionValues;
        this.errorDetail = builder.errorDetail;
    }

    /**
     * Returns true if the PartitionValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPartitionValues() {
        return partitionValues != null && !(partitionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values that define the partition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPartitionValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values that define the partition.
     */
    public List<String> partitionValues() {
        return partitionValues;
    }

    /**
     * <p>
     * The details about the partition error.
     * </p>
     * 
     * @return The details about the partition error.
     */
    public ErrorDetail errorDetail() {
        return errorDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(partitionValues());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionError)) {
            return false;
        }
        PartitionError other = (PartitionError) obj;
        return Objects.equals(partitionValues(), other.partitionValues()) && Objects.equals(errorDetail(), other.errorDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PartitionError").add("PartitionValues", partitionValues()).add("ErrorDetail", errorDetail())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PartitionValues":
            return Optional.ofNullable(clazz.cast(partitionValues()));
        case "ErrorDetail":
            return Optional.ofNullable(clazz.cast(errorDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PartitionError, T> g) {
        return obj -> g.apply((PartitionError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PartitionError> {
        /**
         * <p>
         * The values that define the partition.
         * </p>
         * 
         * @param partitionValues
         *        The values that define the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValues(Collection<String> partitionValues);

        /**
         * <p>
         * The values that define the partition.
         * </p>
         * 
         * @param partitionValues
         *        The values that define the partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionValues(String... partitionValues);

        /**
         * <p>
         * The details about the partition error.
         * </p>
         * 
         * @param errorDetail
         *        The details about the partition error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetail(ErrorDetail errorDetail);

        /**
         * <p>
         * The details about the partition error.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to create
         * one manually via {@link ErrorDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #errorDetail(ErrorDetail)}.
         * 
         * @param errorDetail
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetail(ErrorDetail)
         */
        default Builder errorDetail(Consumer<ErrorDetail.Builder> errorDetail) {
            return errorDetail(ErrorDetail.builder().applyMutation(errorDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<String> partitionValues = DefaultSdkAutoConstructList.getInstance();

        private ErrorDetail errorDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(PartitionError model) {
            partitionValues(model.partitionValues);
            errorDetail(model.errorDetail);
        }

        public final Collection<String> getPartitionValues() {
            return partitionValues;
        }

        @Override
        public final Builder partitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionValues(String... partitionValues) {
            partitionValues(Arrays.asList(partitionValues));
            return this;
        }

        public final void setPartitionValues(Collection<String> partitionValues) {
            this.partitionValues = ValueStringListCopier.copy(partitionValues);
        }

        public final ErrorDetail.Builder getErrorDetail() {
            return errorDetail != null ? errorDetail.toBuilder() : null;
        }

        @Override
        public final Builder errorDetail(ErrorDetail errorDetail) {
            this.errorDetail = errorDetail;
            return this;
        }

        public final void setErrorDetail(ErrorDetail.BuilderImpl errorDetail) {
            this.errorDetail = errorDetail != null ? errorDetail.build() : null;
        }

        @Override
        public PartitionError build() {
            return new PartitionError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
