/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A policy that specifies update and deletion behaviors for the crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SchemaChangePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<SchemaChangePolicy.Builder, SchemaChangePolicy> {
    private static final SdkField<String> UPDATE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SchemaChangePolicy::updateBehaviorAsString)).setter(setter(Builder::updateBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateBehavior").build()).build();

    private static final SdkField<String> DELETE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SchemaChangePolicy::deleteBehaviorAsString)).setter(setter(Builder::deleteBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_BEHAVIOR_FIELD,
            DELETE_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String updateBehavior;

    private final String deleteBehavior;

    private SchemaChangePolicy(BuilderImpl builder) {
        this.updateBehavior = builder.updateBehavior;
        this.deleteBehavior = builder.deleteBehavior;
    }

    /**
     * <p>
     * The update behavior when the crawler finds a changed schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateBehavior}
     * will return {@link UpdateBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateBehaviorAsString}.
     * </p>
     * 
     * @return The update behavior when the crawler finds a changed schema.
     * @see UpdateBehavior
     */
    public UpdateBehavior updateBehavior() {
        return UpdateBehavior.fromValue(updateBehavior);
    }

    /**
     * <p>
     * The update behavior when the crawler finds a changed schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateBehavior}
     * will return {@link UpdateBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateBehaviorAsString}.
     * </p>
     * 
     * @return The update behavior when the crawler finds a changed schema.
     * @see UpdateBehavior
     */
    public String updateBehaviorAsString() {
        return updateBehavior;
    }

    /**
     * <p>
     * The deletion behavior when the crawler finds a deleted object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteBehavior}
     * will return {@link DeleteBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deleteBehaviorAsString}.
     * </p>
     * 
     * @return The deletion behavior when the crawler finds a deleted object.
     * @see DeleteBehavior
     */
    public DeleteBehavior deleteBehavior() {
        return DeleteBehavior.fromValue(deleteBehavior);
    }

    /**
     * <p>
     * The deletion behavior when the crawler finds a deleted object.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deleteBehavior}
     * will return {@link DeleteBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #deleteBehaviorAsString}.
     * </p>
     * 
     * @return The deletion behavior when the crawler finds a deleted object.
     * @see DeleteBehavior
     */
    public String deleteBehaviorAsString() {
        return deleteBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updateBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deleteBehaviorAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaChangePolicy)) {
            return false;
        }
        SchemaChangePolicy other = (SchemaChangePolicy) obj;
        return Objects.equals(updateBehaviorAsString(), other.updateBehaviorAsString())
                && Objects.equals(deleteBehaviorAsString(), other.deleteBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SchemaChangePolicy").add("UpdateBehavior", updateBehaviorAsString())
                .add("DeleteBehavior", deleteBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateBehavior":
            return Optional.ofNullable(clazz.cast(updateBehaviorAsString()));
        case "DeleteBehavior":
            return Optional.ofNullable(clazz.cast(deleteBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaChangePolicy, T> g) {
        return obj -> g.apply((SchemaChangePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SchemaChangePolicy> {
        /**
         * <p>
         * The update behavior when the crawler finds a changed schema.
         * </p>
         * 
         * @param updateBehavior
         *        The update behavior when the crawler finds a changed schema.
         * @see UpdateBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateBehavior
         */
        Builder updateBehavior(String updateBehavior);

        /**
         * <p>
         * The update behavior when the crawler finds a changed schema.
         * </p>
         * 
         * @param updateBehavior
         *        The update behavior when the crawler finds a changed schema.
         * @see UpdateBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateBehavior
         */
        Builder updateBehavior(UpdateBehavior updateBehavior);

        /**
         * <p>
         * The deletion behavior when the crawler finds a deleted object.
         * </p>
         * 
         * @param deleteBehavior
         *        The deletion behavior when the crawler finds a deleted object.
         * @see DeleteBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteBehavior
         */
        Builder deleteBehavior(String deleteBehavior);

        /**
         * <p>
         * The deletion behavior when the crawler finds a deleted object.
         * </p>
         * 
         * @param deleteBehavior
         *        The deletion behavior when the crawler finds a deleted object.
         * @see DeleteBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeleteBehavior
         */
        Builder deleteBehavior(DeleteBehavior deleteBehavior);
    }

    static final class BuilderImpl implements Builder {
        private String updateBehavior;

        private String deleteBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaChangePolicy model) {
            updateBehavior(model.updateBehavior);
            deleteBehavior(model.deleteBehavior);
        }

        public final String getUpdateBehaviorAsString() {
            return updateBehavior;
        }

        @Override
        public final Builder updateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
            return this;
        }

        @Override
        public final Builder updateBehavior(UpdateBehavior updateBehavior) {
            this.updateBehavior(updateBehavior == null ? null : updateBehavior.toString());
            return this;
        }

        public final void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        public final String getDeleteBehaviorAsString() {
            return deleteBehavior;
        }

        @Override
        public final Builder deleteBehavior(String deleteBehavior) {
            this.deleteBehavior = deleteBehavior;
            return this;
        }

        @Override
        public final Builder deleteBehavior(DeleteBehavior deleteBehavior) {
            this.deleteBehavior(deleteBehavior == null ? null : deleteBehavior.toString());
            return this;
        }

        public final void setDeleteBehavior(String deleteBehavior) {
            this.deleteBehavior = deleteBehavior;
        }

        @Override
        public SchemaChangePolicy build() {
            return new SchemaChangePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
