/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlTransformRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateMlTransformRequest.Builder, UpdateMlTransformRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::transformId)).setter(setter(Builder::transformId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<TransformParameters> PARAMETERS_FIELD = SdkField
            .<TransformParameters> builder(MarshallingType.SDK_POJO).getter(getter(UpdateMlTransformRequest::parameters))
            .setter(setter(Builder::parameters)).constructor(TransformParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> GLUE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::glueVersion)).setter(setter(Builder::glueVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueVersion").build()).build();

    private static final SdkField<Double> MAX_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(UpdateMlTransformRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<String> WORKER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateMlTransformRequest::workerTypeAsString)).setter(setter(Builder::workerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMlTransformRequest::numberOfWorkers)).setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMlTransformRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateMlTransformRequest::maxRetries)).setter(setter(Builder::maxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRetries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, PARAMETERS_FIELD, ROLE_FIELD, GLUE_VERSION_FIELD, MAX_CAPACITY_FIELD,
            WORKER_TYPE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, MAX_RETRIES_FIELD));

    private final String transformId;

    private final String name;

    private final String description;

    private final TransformParameters parameters;

    private final String role;

    private final String glueVersion;

    private final Double maxCapacity;

    private final String workerType;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final Integer maxRetries;

    private UpdateMlTransformRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.role = builder.role;
        this.glueVersion = builder.glueVersion;
        this.maxCapacity = builder.maxCapacity;
        this.workerType = builder.workerType;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.maxRetries = builder.maxRetries;
    }

    /**
     * <p>
     * A unique identifier that was generated when the transform was created.
     * </p>
     * 
     * @return A unique identifier that was generated when the transform was created.
     */
    public String transformId() {
        return transformId;
    }

    /**
     * <p>
     * The unique name that you gave the transform when you created it.
     * </p>
     * 
     * @return The unique name that you gave the transform when you created it.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the transform. The default is an empty string.
     * </p>
     * 
     * @return A description of the transform. The default is an empty string.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The configuration parameters that are specific to the transform type (algorithm) used. Conditionally dependent on
     * the transform type.
     * </p>
     * 
     * @return The configuration parameters that are specific to the transform type (algorithm) used. Conditionally
     *         dependent on the transform type.
     */
    public TransformParameters parameters() {
        return parameters;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0 is
     * recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue Versions</a>
     * in the developer guide.
     * </p>
     * 
     * @return This value determines which version of AWS Glue this machine learning transform is compatible with. Glue
     *         1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue
     *         0.9. For more information, see <a
     *         href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
     *         Versions</a> in the developer guide.
     */
    public String glueVersion() {
        return glueVersion;
    }

    /**
     * <p>
     * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You can
     * allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that consists of
     * 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     * href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
     * </p>
     * <p>
     * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     * <code>MaxCapacity</code> field is set automatically and becomes read-only.
     * </p>
     * 
     * @return The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform.
     *         You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power
     *         that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
     *         href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
     *         <p>
     *         When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
     *         <code>MaxCapacity</code> field is set automatically and becomes read-only.
     */
    public Double maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public WorkerType workerType() {
        return WorkerType.fromValue(workerType);
    }

    /**
     * <p>
     * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or G.2X.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2
     * executors per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
     * executor per worker.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workerType} will
     * return {@link WorkerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workerTypeAsString}.
     * </p>
     * 
     * @return The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X,
     *         or G.2X.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk,
     *         and 2 executors per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and
     *         1 executor per worker.
     *         </p>
     *         </li>
     * @see WorkerType
     */
    public String workerTypeAsString() {
        return workerType;
    }

    /**
     * <p>
     * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
     * </p>
     * 
     * @return The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
     */
    public Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this
     * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default is
     * 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a task run for this transform in minutes. This is the maximum time that a task run for
     *         this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The
     *         default is 2,880 minutes (48 hours).
     */
    public Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The maximum number of times to retry a task for this transform after a task run fails.
     * </p>
     * 
     * @return The maximum number of times to retry a task for this transform after a task run fails.
     */
    public Integer maxRetries() {
        return maxRetries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transformId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(glueVersion());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(workerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(maxRetries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlTransformRequest)) {
            return false;
        }
        UpdateMlTransformRequest other = (UpdateMlTransformRequest) obj;
        return Objects.equals(transformId(), other.transformId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(parameters(), other.parameters())
                && Objects.equals(role(), other.role()) && Objects.equals(glueVersion(), other.glueVersion())
                && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(workerTypeAsString(), other.workerTypeAsString())
                && Objects.equals(numberOfWorkers(), other.numberOfWorkers()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(maxRetries(), other.maxRetries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateMlTransformRequest").add("TransformId", transformId()).add("Name", name())
                .add("Description", description()).add("Parameters", parameters()).add("Role", role())
                .add("GlueVersion", glueVersion()).add("MaxCapacity", maxCapacity()).add("WorkerType", workerTypeAsString())
                .add("NumberOfWorkers", numberOfWorkers()).add("Timeout", timeout()).add("MaxRetries", maxRetries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransformId":
            return Optional.ofNullable(clazz.cast(transformId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "GlueVersion":
            return Optional.ofNullable(clazz.cast(glueVersion()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "WorkerType":
            return Optional.ofNullable(clazz.cast(workerTypeAsString()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MaxRetries":
            return Optional.ofNullable(clazz.cast(maxRetries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlTransformRequest, T> g) {
        return obj -> g.apply((UpdateMlTransformRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMlTransformRequest> {
        /**
         * <p>
         * A unique identifier that was generated when the transform was created.
         * </p>
         * 
         * @param transformId
         *        A unique identifier that was generated when the transform was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformId(String transformId);

        /**
         * <p>
         * The unique name that you gave the transform when you created it.
         * </p>
         * 
         * @param name
         *        The unique name that you gave the transform when you created it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the transform. The default is an empty string.
         * </p>
         * 
         * @param description
         *        A description of the transform. The default is an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The configuration parameters that are specific to the transform type (algorithm) used. Conditionally
         * dependent on the transform type.
         * </p>
         * 
         * @param parameters
         *        The configuration parameters that are specific to the transform type (algorithm) used. Conditionally
         *        dependent on the transform type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(TransformParameters parameters);

        /**
         * <p>
         * The configuration parameters that are specific to the transform type (algorithm) used. Conditionally
         * dependent on the transform type.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformParameters.Builder} avoiding the need
         * to create one manually via {@link TransformParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(TransformParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link TransformParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(TransformParameters)
         */
        default Builder parameters(Consumer<TransformParameters.Builder> parameters) {
            return parameters(TransformParameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
         * </p>
         * 
         * @param role
         *        The name or Amazon Resource Name (ARN) of the IAM role with the required permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * This value determines which version of AWS Glue this machine learning transform is compatible with. Glue 1.0
         * is recommended for most customers. If the value is not set, the Glue compatibility defaults to Glue 0.9. For
         * more information, see <a
         * href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
         * Versions</a> in the developer guide.
         * </p>
         * 
         * @param glueVersion
         *        This value determines which version of AWS Glue this machine learning transform is compatible with.
         *        Glue 1.0 is recommended for most customers. If the value is not set, the Glue compatibility defaults
         *        to Glue 0.9. For more information, see <a
         *        href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html#release-notes-versions">AWS Glue
         *        Versions</a> in the developer guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueVersion(String glueVersion);

        /**
         * <p>
         * The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this transform. You
         * can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of processing power that
         * consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information, see the <a
         * href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>.
         * </p>
         * <p>
         * When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         * <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * </p>
         * 
         * @param maxCapacity
         *        The number of AWS Glue data processing units (DPUs) that are allocated to task runs for this
         *        transform. You can allocate from 2 to 100 DPUs; the default is 10. A DPU is a relative measure of
         *        processing power that consists of 4 vCPUs of compute capacity and 16 GB of memory. For more
         *        information, see the <a href="https://aws.amazon.com/glue/pricing/">AWS Glue pricing page</a>. </p>
         *        <p>
         *        When the <code>WorkerType</code> field is set to a value other than <code>Standard</code>, the
         *        <code>MaxCapacity</code> field is set automatically and becomes read-only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Double maxCapacity);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(String workerType);

        /**
         * <p>
         * The type of predefined worker that is allocated when this task runs. Accepts a value of Standard, G.1X, or
         * G.2X.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and
         * 2 executors per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk, and 1
         * executor per worker.
         * </p>
         * </li>
         * </ul>
         * 
         * @param workerType
         *        The type of predefined worker that is allocated when this task runs. Accepts a value of Standard,
         *        G.1X, or G.2X.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For the <code>Standard</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 50GB
         *        disk, and 2 executors per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.1X</code> worker type, each worker provides 4 vCPU, 16 GB of memory and a 64GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For the <code>G.2X</code> worker type, each worker provides 8 vCPU, 32 GB of memory and a 128GB disk,
         *        and 1 executor per worker.
         *        </p>
         *        </li>
         * @see WorkerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkerType
         */
        Builder workerType(WorkerType workerType);

        /**
         * <p>
         * The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of workers of a defined <code>workerType</code> that are allocated when this task runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a task run for this transform in minutes. This is the maximum time that a task run for this
         * transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status. The default
         * is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a task run for this transform in minutes. This is the maximum time that a task run for
         *        this transform can consume resources before it is terminated and enters <code>TIMEOUT</code> status.
         *        The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The maximum number of times to retry a task for this transform after a task run fails.
         * </p>
         * 
         * @param maxRetries
         *        The maximum number of times to retry a task for this transform after a task run fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRetries(Integer maxRetries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String transformId;

        private String name;

        private String description;

        private TransformParameters parameters;

        private String role;

        private String glueVersion;

        private Double maxCapacity;

        private String workerType;

        private Integer numberOfWorkers;

        private Integer timeout;

        private Integer maxRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlTransformRequest model) {
            super(model);
            transformId(model.transformId);
            name(model.name);
            description(model.description);
            parameters(model.parameters);
            role(model.role);
            glueVersion(model.glueVersion);
            maxCapacity(model.maxCapacity);
            workerType(model.workerType);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            maxRetries(model.maxRetries);
        }

        public final String getTransformId() {
            return transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final TransformParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(TransformParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(TransformParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getGlueVersion() {
            return glueVersion;
        }

        @Override
        public final Builder glueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        public final void setGlueVersion(String glueVersion) {
            this.glueVersion = glueVersion;
        }

        public final Double getMaxCapacity() {
            return maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Double maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final String getWorkerTypeAsString() {
            return workerType;
        }

        @Override
        public final Builder workerType(String workerType) {
            this.workerType = workerType;
            return this;
        }

        @Override
        public final Builder workerType(WorkerType workerType) {
            this.workerType(workerType == null ? null : workerType.toString());
            return this;
        }

        public final void setWorkerType(String workerType) {
            this.workerType = workerType;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMaxRetries() {
            return maxRetries;
        }

        @Override
        public final Builder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public final void setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMlTransformRequest build() {
            return new UpdateMlTransformRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
