/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTableRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<TableInput> TABLE_INPUT_FIELD = SdkField.<TableInput> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateTableRequest::tableInput)).setter(setter(Builder::tableInput)).constructor(TableInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableInput").build()).build();

    private static final SdkField<Boolean> SKIP_ARCHIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateTableRequest::skipArchive)).setter(setter(Builder::skipArchive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipArchive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_INPUT_FIELD, SKIP_ARCHIVE_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final TableInput tableInput;

    private final Boolean skipArchive;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableInput = builder.tableInput;
        this.skipArchive = builder.skipArchive;
    }

    /**
     * <p>
     * The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by default.
     * </p>
     * 
     * @return The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
     *         default.
     */
    public String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely
     * lowercase.
     * </p>
     * 
     * @return The name of the catalog database in which the table resides. For Hive compatibility, this name is
     *         entirely lowercase.
     */
    public String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * An updated <code>TableInput</code> object to define the metadata table in the catalog.
     * </p>
     * 
     * @return An updated <code>TableInput</code> object to define the metadata table in the catalog.
     */
    public TableInput tableInput() {
        return tableInput;
    }

    /**
     * <p>
     * By default, <code>UpdateTable</code> always creates an archived version of the table before updating it. However,
     * if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the archived version.
     * </p>
     * 
     * @return By default, <code>UpdateTable</code> always creates an archived version of the table before updating it.
     *         However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the
     *         archived version.
     */
    public Boolean skipArchive() {
        return skipArchive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableInput());
        hashCode = 31 * hashCode + Objects.hashCode(skipArchive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableInput(), other.tableInput()) && Objects.equals(skipArchive(), other.skipArchive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateTableRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableInput", tableInput()).add("SkipArchive", skipArchive()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableInput":
            return Optional.ofNullable(clazz.cast(tableInput()));
        case "SkipArchive":
            return Optional.ofNullable(clazz.cast(skipArchive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
         * default.
         * </p>
         * 
         * @param catalogId
         *        The ID of the Data Catalog where the table resides. If none is provided, the AWS account ID is used by
         *        default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the catalog database in which the table resides. For Hive compatibility, this name is entirely
         * lowercase.
         * </p>
         * 
         * @param databaseName
         *        The name of the catalog database in which the table resides. For Hive compatibility, this name is
         *        entirely lowercase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * </p>
         * 
         * @param tableInput
         *        An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableInput(TableInput tableInput);

        /**
         * <p>
         * An updated <code>TableInput</code> object to define the metadata table in the catalog.
         * </p>
         * This is a convenience that creates an instance of the {@link TableInput.Builder} avoiding the need to create
         * one manually via {@link TableInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableInput.Builder#build()} is called immediately and its result
         * is passed to {@link #tableInput(TableInput)}.
         * 
         * @param tableInput
         *        a consumer that will call methods on {@link TableInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableInput(TableInput)
         */
        default Builder tableInput(Consumer<TableInput.Builder> tableInput) {
            return tableInput(TableInput.builder().applyMutation(tableInput).build());
        }

        /**
         * <p>
         * By default, <code>UpdateTable</code> always creates an archived version of the table before updating it.
         * However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the archived
         * version.
         * </p>
         * 
         * @param skipArchive
         *        By default, <code>UpdateTable</code> always creates an archived version of the table before updating
         *        it. However, if <code>skipArchive</code> is set to true, <code>UpdateTable</code> does not create the
         *        archived version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipArchive(Boolean skipArchive);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private TableInput tableInput;

        private Boolean skipArchive;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableInput(model.tableInput);
            skipArchive(model.skipArchive);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final TableInput.Builder getTableInput() {
            return tableInput != null ? tableInput.toBuilder() : null;
        }

        @Override
        public final Builder tableInput(TableInput tableInput) {
            this.tableInput = tableInput;
            return this;
        }

        public final void setTableInput(TableInput.BuilderImpl tableInput) {
            this.tableInput = tableInput != null ? tableInput.build() : null;
        }

        public final Boolean getSkipArchive() {
            return skipArchive;
        }

        @Override
        public final Builder skipArchive(Boolean skipArchive) {
            this.skipArchive = skipArchive;
            return this;
        }

        public final void setSkipArchive(Boolean skipArchive) {
            this.skipArchive = skipArchive;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
