/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataQualityRulesetEvaluationRunResponse extends GlueResponse implements
        ToCopyableBuilder<GetDataQualityRulesetEvaluationRunResponse.Builder, GetDataQualityRulesetEvaluationRunResponse> {
    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RunId")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(GetDataQualityRulesetEvaluationRunResponse::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> NUMBER_OF_WORKERS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfWorkers").getter(getter(GetDataQualityRulesetEvaluationRunResponse::numberOfWorkers))
            .setter(setter(Builder::numberOfWorkers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfWorkers").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(GetDataQualityRulesetEvaluationRunResponse::timeout))
            .setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<DataQualityEvaluationRunAdditionalRunOptions> ADDITIONAL_RUN_OPTIONS_FIELD = SdkField
            .<DataQualityEvaluationRunAdditionalRunOptions> builder(MarshallingType.SDK_POJO).memberName("AdditionalRunOptions")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::additionalRunOptions))
            .setter(setter(Builder::additionalRunOptions)).constructor(DataQualityEvaluationRunAdditionalRunOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRunOptions").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorString").getter(getter(GetDataQualityRulesetEvaluationRunResponse::errorString))
            .setter(setter(Builder::errorString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorString").build()).build();

    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedOn").getter(getter(GetDataQualityRulesetEvaluationRunResponse::startedOn))
            .setter(setter(Builder::startedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedOn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedOn").getter(getter(GetDataQualityRulesetEvaluationRunResponse::lastModifiedOn))
            .setter(setter(Builder::lastModifiedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()).build();

    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedOn").getter(getter(GetDataQualityRulesetEvaluationRunResponse::completedOn))
            .setter(setter(Builder::completedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedOn").build()).build();

    private static final SdkField<Integer> EXECUTION_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExecutionTime").getter(getter(GetDataQualityRulesetEvaluationRunResponse::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()).build();

    private static final SdkField<List<String>> RULESET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RulesetNames")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::rulesetNames))
            .setter(setter(Builder::rulesetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESULT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResultIds")
            .getter(getter(GetDataQualityRulesetEvaluationRunResponse::resultIds))
            .setter(setter(Builder::resultIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUN_ID_FIELD,
            DATA_SOURCE_FIELD, ROLE_FIELD, NUMBER_OF_WORKERS_FIELD, TIMEOUT_FIELD, ADDITIONAL_RUN_OPTIONS_FIELD, STATUS_FIELD,
            ERROR_STRING_FIELD, STARTED_ON_FIELD, LAST_MODIFIED_ON_FIELD, COMPLETED_ON_FIELD, EXECUTION_TIME_FIELD,
            RULESET_NAMES_FIELD, RESULT_IDS_FIELD));

    private final String runId;

    private final DataSource dataSource;

    private final String role;

    private final Integer numberOfWorkers;

    private final Integer timeout;

    private final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;

    private final String status;

    private final String errorString;

    private final Instant startedOn;

    private final Instant lastModifiedOn;

    private final Instant completedOn;

    private final Integer executionTime;

    private final List<String> rulesetNames;

    private final List<String> resultIds;

    private GetDataQualityRulesetEvaluationRunResponse(BuilderImpl builder) {
        super(builder);
        this.runId = builder.runId;
        this.dataSource = builder.dataSource;
        this.role = builder.role;
        this.numberOfWorkers = builder.numberOfWorkers;
        this.timeout = builder.timeout;
        this.additionalRunOptions = builder.additionalRunOptions;
        this.status = builder.status;
        this.errorString = builder.errorString;
        this.startedOn = builder.startedOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.completedOn = builder.completedOn;
        this.executionTime = builder.executionTime;
        this.rulesetNames = builder.rulesetNames;
        this.resultIds = builder.resultIds;
    }

    /**
     * <p>
     * The unique run identifier associated with this run.
     * </p>
     * 
     * @return The unique run identifier associated with this run.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * The data source (an Glue table) associated with this evaluation run.
     * </p>
     * 
     * @return The data source (an Glue table) associated with this evaluation run.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * An IAM role supplied to encrypt the results of the run.
     * </p>
     * 
     * @return An IAM role supplied to encrypt the results of the run.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     * </p>
     * 
     * @return The number of <code>G.1X</code> workers to be used in the run. The default is 5.
     */
    public final Integer numberOfWorkers() {
        return numberOfWorkers;
    }

    /**
     * <p>
     * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     * </p>
     * 
     * @return The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
     *         terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * Additional run options you can specify for an evaluation run.
     * </p>
     * 
     * @return Additional run options you can specify for an evaluation run.
     */
    public final DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions() {
        return additionalRunOptions;
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final TaskStatusType status() {
        return TaskStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status for this run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TaskStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status for this run.
     * @see TaskStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error strings that are associated with the run.
     * </p>
     * 
     * @return The error strings that are associated with the run.
     */
    public final String errorString() {
        return errorString;
    }

    /**
     * <p>
     * The date and time when this run started.
     * </p>
     * 
     * @return The date and time when this run started.
     */
    public final Instant startedOn() {
        return startedOn;
    }

    /**
     * <p>
     * A timestamp. The last point in time when this data quality rule recommendation run was modified.
     * </p>
     * 
     * @return A timestamp. The last point in time when this data quality rule recommendation run was modified.
     */
    public final Instant lastModifiedOn() {
        return lastModifiedOn;
    }

    /**
     * <p>
     * The date and time when this run was completed.
     * </p>
     * 
     * @return The date and time when this run was completed.
     */
    public final Instant completedOn() {
        return completedOn;
    }

    /**
     * <p>
     * The amount of time (in seconds) that the run consumed resources.
     * </p>
     * 
     * @return The amount of time (in seconds) that the run consumed resources.
     */
    public final Integer executionTime() {
        return executionTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the RulesetNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRulesetNames() {
        return rulesetNames != null && !(rulesetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ruleset names for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRulesetNames} method.
     * </p>
     * 
     * @return A list of ruleset names for the run.
     */
    public final List<String> rulesetNames() {
        return rulesetNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResultIds() {
        return resultIds != null && !(resultIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of result IDs for the data quality results for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultIds} method.
     * </p>
     * 
     * @return A list of result IDs for the data quality results for the run.
     */
    public final List<String> resultIds() {
        return resultIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(additionalRunOptions());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorString());
        hashCode = 31 * hashCode + Objects.hashCode(startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasRulesetNames() ? rulesetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultIds() ? resultIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityRulesetEvaluationRunResponse)) {
            return false;
        }
        GetDataQualityRulesetEvaluationRunResponse other = (GetDataQualityRulesetEvaluationRunResponse) obj;
        return Objects.equals(runId(), other.runId()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(role(), other.role()) && Objects.equals(numberOfWorkers(), other.numberOfWorkers())
                && Objects.equals(timeout(), other.timeout())
                && Objects.equals(additionalRunOptions(), other.additionalRunOptions())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorString(), other.errorString())
                && Objects.equals(startedOn(), other.startedOn()) && Objects.equals(lastModifiedOn(), other.lastModifiedOn())
                && Objects.equals(completedOn(), other.completedOn()) && Objects.equals(executionTime(), other.executionTime())
                && hasRulesetNames() == other.hasRulesetNames() && Objects.equals(rulesetNames(), other.rulesetNames())
                && hasResultIds() == other.hasResultIds() && Objects.equals(resultIds(), other.resultIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataQualityRulesetEvaluationRunResponse").add("RunId", runId())
                .add("DataSource", dataSource()).add("Role", role()).add("NumberOfWorkers", numberOfWorkers())
                .add("Timeout", timeout()).add("AdditionalRunOptions", additionalRunOptions()).add("Status", statusAsString())
                .add("ErrorString", errorString()).add("StartedOn", startedOn()).add("LastModifiedOn", lastModifiedOn())
                .add("CompletedOn", completedOn()).add("ExecutionTime", executionTime())
                .add("RulesetNames", hasRulesetNames() ? rulesetNames() : null)
                .add("ResultIds", hasResultIds() ? resultIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RunId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "NumberOfWorkers":
            return Optional.ofNullable(clazz.cast(numberOfWorkers()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "AdditionalRunOptions":
            return Optional.ofNullable(clazz.cast(additionalRunOptions()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorString":
            return Optional.ofNullable(clazz.cast(errorString()));
        case "StartedOn":
            return Optional.ofNullable(clazz.cast(startedOn()));
        case "LastModifiedOn":
            return Optional.ofNullable(clazz.cast(lastModifiedOn()));
        case "CompletedOn":
            return Optional.ofNullable(clazz.cast(completedOn()));
        case "ExecutionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        case "RulesetNames":
            return Optional.ofNullable(clazz.cast(rulesetNames()));
        case "ResultIds":
            return Optional.ofNullable(clazz.cast(resultIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityRulesetEvaluationRunResponse, T> g) {
        return obj -> g.apply((GetDataQualityRulesetEvaluationRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDataQualityRulesetEvaluationRunResponse> {
        /**
         * <p>
         * The unique run identifier associated with this run.
         * </p>
         * 
         * @param runId
         *        The unique run identifier associated with this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * The data source (an Glue table) associated with this evaluation run.
         * </p>
         * 
         * @param dataSource
         *        The data source (an Glue table) associated with this evaluation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The data source (an Glue table) associated with this evaluation run.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSource.Builder} avoiding the need to
         * create one manually via {@link DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * An IAM role supplied to encrypt the results of the run.
         * </p>
         * 
         * @param role
         *        An IAM role supplied to encrypt the results of the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * </p>
         * 
         * @param numberOfWorkers
         *        The number of <code>G.1X</code> workers to be used in the run. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfWorkers(Integer numberOfWorkers);

        /**
         * <p>
         * The timeout for a run in minutes. This is the maximum time that a run can consume resources before it is
         * terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * </p>
         * 
         * @param timeout
         *        The timeout for a run in minutes. This is the maximum time that a run can consume resources before it
         *        is terminated and enters <code>TIMEOUT</code> status. The default is 2,880 minutes (48 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * Additional run options you can specify for an evaluation run.
         * </p>
         * 
         * @param additionalRunOptions
         *        Additional run options you can specify for an evaluation run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions);

        /**
         * <p>
         * Additional run options you can specify for an evaluation run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataQualityEvaluationRunAdditionalRunOptions.Builder} avoiding the need to create one manually via
         * {@link DataQualityEvaluationRunAdditionalRunOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataQualityEvaluationRunAdditionalRunOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions)}.
         * 
         * @param additionalRunOptions
         *        a consumer that will call methods on {@link DataQualityEvaluationRunAdditionalRunOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions)
         */
        default Builder additionalRunOptions(Consumer<DataQualityEvaluationRunAdditionalRunOptions.Builder> additionalRunOptions) {
            return additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.builder()
                    .applyMutation(additionalRunOptions).build());
        }

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status for this run.
         * </p>
         * 
         * @param status
         *        The status for this run.
         * @see TaskStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskStatusType
         */
        Builder status(TaskStatusType status);

        /**
         * <p>
         * The error strings that are associated with the run.
         * </p>
         * 
         * @param errorString
         *        The error strings that are associated with the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorString(String errorString);

        /**
         * <p>
         * The date and time when this run started.
         * </p>
         * 
         * @param startedOn
         *        The date and time when this run started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedOn(Instant startedOn);

        /**
         * <p>
         * A timestamp. The last point in time when this data quality rule recommendation run was modified.
         * </p>
         * 
         * @param lastModifiedOn
         *        A timestamp. The last point in time when this data quality rule recommendation run was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedOn(Instant lastModifiedOn);

        /**
         * <p>
         * The date and time when this run was completed.
         * </p>
         * 
         * @param completedOn
         *        The date and time when this run was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedOn(Instant completedOn);

        /**
         * <p>
         * The amount of time (in seconds) that the run consumed resources.
         * </p>
         * 
         * @param executionTime
         *        The amount of time (in seconds) that the run consumed resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Integer executionTime);

        /**
         * <p>
         * A list of ruleset names for the run.
         * </p>
         * 
         * @param rulesetNames
         *        A list of ruleset names for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetNames(Collection<String> rulesetNames);

        /**
         * <p>
         * A list of ruleset names for the run.
         * </p>
         * 
         * @param rulesetNames
         *        A list of ruleset names for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rulesetNames(String... rulesetNames);

        /**
         * <p>
         * A list of result IDs for the data quality results for the run.
         * </p>
         * 
         * @param resultIds
         *        A list of result IDs for the data quality results for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultIds(Collection<String> resultIds);

        /**
         * <p>
         * A list of result IDs for the data quality results for the run.
         * </p>
         * 
         * @param resultIds
         *        A list of result IDs for the data quality results for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultIds(String... resultIds);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String runId;

        private DataSource dataSource;

        private String role;

        private Integer numberOfWorkers;

        private Integer timeout;

        private DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions;

        private String status;

        private String errorString;

        private Instant startedOn;

        private Instant lastModifiedOn;

        private Instant completedOn;

        private Integer executionTime;

        private List<String> rulesetNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resultIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityRulesetEvaluationRunResponse model) {
            super(model);
            runId(model.runId);
            dataSource(model.dataSource);
            role(model.role);
            numberOfWorkers(model.numberOfWorkers);
            timeout(model.timeout);
            additionalRunOptions(model.additionalRunOptions);
            status(model.status);
            errorString(model.errorString);
            startedOn(model.startedOn);
            lastModifiedOn(model.lastModifiedOn);
            completedOn(model.completedOn);
            executionTime(model.executionTime);
            rulesetNames(model.rulesetNames);
            resultIds(model.resultIds);
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getNumberOfWorkers() {
            return numberOfWorkers;
        }

        public final void setNumberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        @Override
        public final Builder numberOfWorkers(Integer numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final DataQualityEvaluationRunAdditionalRunOptions.Builder getAdditionalRunOptions() {
            return additionalRunOptions != null ? additionalRunOptions.toBuilder() : null;
        }

        public final void setAdditionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions.BuilderImpl additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions != null ? additionalRunOptions.build() : null;
        }

        @Override
        public final Builder additionalRunOptions(DataQualityEvaluationRunAdditionalRunOptions additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TaskStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorString() {
            return errorString;
        }

        public final void setErrorString(String errorString) {
            this.errorString = errorString;
        }

        @Override
        public final Builder errorString(String errorString) {
            this.errorString = errorString;
            return this;
        }

        public final Instant getStartedOn() {
            return startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final Instant getCompletedOn() {
            return completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final Integer getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Integer executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Integer executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final Collection<String> getRulesetNames() {
            if (rulesetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return rulesetNames;
        }

        public final void setRulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
        }

        @Override
        public final Builder rulesetNames(Collection<String> rulesetNames) {
            this.rulesetNames = RulesetNamesCopier.copy(rulesetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulesetNames(String... rulesetNames) {
            rulesetNames(Arrays.asList(rulesetNames));
            return this;
        }

        public final Collection<String> getResultIds() {
            if (resultIds instanceof SdkAutoConstructList) {
                return null;
            }
            return resultIds;
        }

        public final void setResultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdListCopier.copy(resultIds);
        }

        @Override
        public final Builder resultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdListCopier.copy(resultIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultIds(String... resultIds) {
            resultIds(Arrays.asList(resultIds));
            return this;
        }

        @Override
        public GetDataQualityRulesetEvaluationRunResponse build() {
            return new GetDataQualityRulesetEvaluationRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
