/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDevEndpointRequest extends GlueRequest implements
        ToCopyableBuilder<UpdateDevEndpointRequest.Builder, UpdateDevEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(UpdateDevEndpointRequest::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(UpdateDevEndpointRequest::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final SdkField<List<String>> ADD_PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddPublicKeys")
            .getter(getter(UpdateDevEndpointRequest::addPublicKeys))
            .setter(setter(Builder::addPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddPublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DELETE_PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeletePublicKeys")
            .getter(getter(UpdateDevEndpointRequest::deletePublicKeys))
            .setter(setter(Builder::deletePublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletePublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DevEndpointCustomLibraries> CUSTOM_LIBRARIES_FIELD = SdkField
            .<DevEndpointCustomLibraries> builder(MarshallingType.SDK_POJO).memberName("CustomLibraries")
            .getter(getter(UpdateDevEndpointRequest::customLibraries)).setter(setter(Builder::customLibraries))
            .constructor(DevEndpointCustomLibraries::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLibraries").build()).build();

    private static final SdkField<Boolean> UPDATE_ETL_LIBRARIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UpdateEtlLibraries").getter(getter(UpdateDevEndpointRequest::updateEtlLibraries))
            .setter(setter(Builder::updateEtlLibraries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateEtlLibraries").build())
            .build();

    private static final SdkField<List<String>> DELETE_ARGUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeleteArguments")
            .getter(getter(UpdateDevEndpointRequest::deleteArguments))
            .setter(setter(Builder::deleteArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ADD_ARGUMENTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("AddArguments")
            .getter(getter(UpdateDevEndpointRequest::addArguments))
            .setter(setter(Builder::addArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddArguments").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            PUBLIC_KEY_FIELD, ADD_PUBLIC_KEYS_FIELD, DELETE_PUBLIC_KEYS_FIELD, CUSTOM_LIBRARIES_FIELD,
            UPDATE_ETL_LIBRARIES_FIELD, DELETE_ARGUMENTS_FIELD, ADD_ARGUMENTS_FIELD));

    private final String endpointName;

    private final String publicKey;

    private final List<String> addPublicKeys;

    private final List<String> deletePublicKeys;

    private final DevEndpointCustomLibraries customLibraries;

    private final Boolean updateEtlLibraries;

    private final List<String> deleteArguments;

    private final Map<String, String> addArguments;

    private UpdateDevEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.publicKey = builder.publicKey;
        this.addPublicKeys = builder.addPublicKeys;
        this.deletePublicKeys = builder.deletePublicKeys;
        this.customLibraries = builder.customLibraries;
        this.updateEtlLibraries = builder.updateEtlLibraries;
        this.deleteArguments = builder.deleteArguments;
        this.addArguments = builder.addArguments;
    }

    /**
     * <p>
     * The name of the <code>DevEndpoint</code> to be updated.
     * </p>
     * 
     * @return The name of the <code>DevEndpoint</code> to be updated.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The public key for the <code>DevEndpoint</code> to use.
     * </p>
     * 
     * @return The public key for the <code>DevEndpoint</code> to use.
     */
    public final String publicKey() {
        return publicKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddPublicKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddPublicKeys() {
        return addPublicKeys != null && !(addPublicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of public keys for the <code>DevEndpoint</code> to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddPublicKeys} method.
     * </p>
     * 
     * @return The list of public keys for the <code>DevEndpoint</code> to use.
     */
    public final List<String> addPublicKeys() {
        return addPublicKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeletePublicKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeletePublicKeys() {
        return deletePublicKeys != null && !(deletePublicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of public keys to be deleted from the <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeletePublicKeys} method.
     * </p>
     * 
     * @return The list of public keys to be deleted from the <code>DevEndpoint</code>.
     */
    public final List<String> deletePublicKeys() {
        return deletePublicKeys;
    }

    /**
     * <p>
     * Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.
     * </p>
     * 
     * @return Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.
     */
    public final DevEndpointCustomLibraries customLibraries() {
        return customLibraries;
    }

    /**
     * <p>
     * <code>True</code> if the list of custom libraries to be loaded in the development endpoint needs to be updated,
     * or <code>False</code> if otherwise.
     * </p>
     * 
     * @return <code>True</code> if the list of custom libraries to be loaded in the development endpoint needs to be
     *         updated, or <code>False</code> if otherwise.
     */
    public final Boolean updateEtlLibraries() {
        return updateEtlLibraries;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeleteArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeleteArguments() {
        return deleteArguments != null && !(deleteArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of argument keys to be deleted from the map of arguments used to configure the <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeleteArguments} method.
     * </p>
     * 
     * @return The list of argument keys to be deleted from the map of arguments used to configure the
     *         <code>DevEndpoint</code>.
     */
    public final List<String> deleteArguments() {
        return deleteArguments;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddArguments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddArguments() {
        return addArguments != null && !(addArguments instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map of arguments to add the map of arguments used to configure the <code>DevEndpoint</code>.
     * </p>
     * <p>
     * Valid arguments are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"--enable-glue-datacatalog": ""</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
     * provided, the version defaults to Python 2.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddArguments} method.
     * </p>
     * 
     * @return The map of arguments to add the map of arguments used to configure the <code>DevEndpoint</code>.</p>
     *         <p>
     *         Valid arguments are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"--enable-glue-datacatalog": ""</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
     *         parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments
     *         are provided, the version defaults to Python 2.
     */
    public final Map<String, String> addArguments() {
        return addArguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddPublicKeys() ? addPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeletePublicKeys() ? deletePublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customLibraries());
        hashCode = 31 * hashCode + Objects.hashCode(updateEtlLibraries());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeleteArguments() ? deleteArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAddArguments() ? addArguments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDevEndpointRequest)) {
            return false;
        }
        UpdateDevEndpointRequest other = (UpdateDevEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(publicKey(), other.publicKey())
                && hasAddPublicKeys() == other.hasAddPublicKeys() && Objects.equals(addPublicKeys(), other.addPublicKeys())
                && hasDeletePublicKeys() == other.hasDeletePublicKeys()
                && Objects.equals(deletePublicKeys(), other.deletePublicKeys())
                && Objects.equals(customLibraries(), other.customLibraries())
                && Objects.equals(updateEtlLibraries(), other.updateEtlLibraries())
                && hasDeleteArguments() == other.hasDeleteArguments()
                && Objects.equals(deleteArguments(), other.deleteArguments()) && hasAddArguments() == other.hasAddArguments()
                && Objects.equals(addArguments(), other.addArguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDevEndpointRequest").add("EndpointName", endpointName()).add("PublicKey", publicKey())
                .add("AddPublicKeys", hasAddPublicKeys() ? addPublicKeys() : null)
                .add("DeletePublicKeys", hasDeletePublicKeys() ? deletePublicKeys() : null)
                .add("CustomLibraries", customLibraries()).add("UpdateEtlLibraries", updateEtlLibraries())
                .add("DeleteArguments", hasDeleteArguments() ? deleteArguments() : null)
                .add("AddArguments", hasAddArguments() ? addArguments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "AddPublicKeys":
            return Optional.ofNullable(clazz.cast(addPublicKeys()));
        case "DeletePublicKeys":
            return Optional.ofNullable(clazz.cast(deletePublicKeys()));
        case "CustomLibraries":
            return Optional.ofNullable(clazz.cast(customLibraries()));
        case "UpdateEtlLibraries":
            return Optional.ofNullable(clazz.cast(updateEtlLibraries()));
        case "DeleteArguments":
            return Optional.ofNullable(clazz.cast(deleteArguments()));
        case "AddArguments":
            return Optional.ofNullable(clazz.cast(addArguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDevEndpointRequest, T> g) {
        return obj -> g.apply((UpdateDevEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDevEndpointRequest> {
        /**
         * <p>
         * The name of the <code>DevEndpoint</code> to be updated.
         * </p>
         * 
         * @param endpointName
         *        The name of the <code>DevEndpoint</code> to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The public key for the <code>DevEndpoint</code> to use.
         * </p>
         * 
         * @param publicKey
         *        The public key for the <code>DevEndpoint</code> to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * The list of public keys for the <code>DevEndpoint</code> to use.
         * </p>
         * 
         * @param addPublicKeys
         *        The list of public keys for the <code>DevEndpoint</code> to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addPublicKeys(Collection<String> addPublicKeys);

        /**
         * <p>
         * The list of public keys for the <code>DevEndpoint</code> to use.
         * </p>
         * 
         * @param addPublicKeys
         *        The list of public keys for the <code>DevEndpoint</code> to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addPublicKeys(String... addPublicKeys);

        /**
         * <p>
         * The list of public keys to be deleted from the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param deletePublicKeys
         *        The list of public keys to be deleted from the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletePublicKeys(Collection<String> deletePublicKeys);

        /**
         * <p>
         * The list of public keys to be deleted from the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param deletePublicKeys
         *        The list of public keys to be deleted from the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletePublicKeys(String... deletePublicKeys);

        /**
         * <p>
         * Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.
         * </p>
         * 
         * @param customLibraries
         *        Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLibraries(DevEndpointCustomLibraries customLibraries);

        /**
         * <p>
         * Custom Python or Java libraries to be loaded in the <code>DevEndpoint</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DevEndpointCustomLibraries.Builder}
         * avoiding the need to create one manually via {@link DevEndpointCustomLibraries#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DevEndpointCustomLibraries.Builder#build()} is called immediately
         * and its result is passed to {@link #customLibraries(DevEndpointCustomLibraries)}.
         * 
         * @param customLibraries
         *        a consumer that will call methods on {@link DevEndpointCustomLibraries.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customLibraries(DevEndpointCustomLibraries)
         */
        default Builder customLibraries(Consumer<DevEndpointCustomLibraries.Builder> customLibraries) {
            return customLibraries(DevEndpointCustomLibraries.builder().applyMutation(customLibraries).build());
        }

        /**
         * <p>
         * <code>True</code> if the list of custom libraries to be loaded in the development endpoint needs to be
         * updated, or <code>False</code> if otherwise.
         * </p>
         * 
         * @param updateEtlLibraries
         *        <code>True</code> if the list of custom libraries to be loaded in the development endpoint needs to be
         *        updated, or <code>False</code> if otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateEtlLibraries(Boolean updateEtlLibraries);

        /**
         * <p>
         * The list of argument keys to be deleted from the map of arguments used to configure the
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param deleteArguments
         *        The list of argument keys to be deleted from the map of arguments used to configure the
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteArguments(Collection<String> deleteArguments);

        /**
         * <p>
         * The list of argument keys to be deleted from the map of arguments used to configure the
         * <code>DevEndpoint</code>.
         * </p>
         * 
         * @param deleteArguments
         *        The list of argument keys to be deleted from the map of arguments used to configure the
         *        <code>DevEndpoint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteArguments(String... deleteArguments);

        /**
         * <p>
         * The map of arguments to add the map of arguments used to configure the <code>DevEndpoint</code>.
         * </p>
         * <p>
         * Valid arguments are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"--enable-glue-datacatalog": ""</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can specify a version of Python support for development endpoints by using the <code>Arguments</code>
         * parameter in the <code>CreateDevEndpoint</code> or <code>UpdateDevEndpoint</code> APIs. If no arguments are
         * provided, the version defaults to Python 2.
         * </p>
         * 
         * @param addArguments
         *        The map of arguments to add the map of arguments used to configure the <code>DevEndpoint</code>.</p>
         *        <p>
         *        Valid arguments are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"--enable-glue-datacatalog": ""</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can specify a version of Python support for development endpoints by using the
         *        <code>Arguments</code> parameter in the <code>CreateDevEndpoint</code> or
         *        <code>UpdateDevEndpoint</code> APIs. If no arguments are provided, the version defaults to Python 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addArguments(Map<String, String> addArguments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String publicKey;

        private List<String> addPublicKeys = DefaultSdkAutoConstructList.getInstance();

        private List<String> deletePublicKeys = DefaultSdkAutoConstructList.getInstance();

        private DevEndpointCustomLibraries customLibraries;

        private Boolean updateEtlLibraries;

        private List<String> deleteArguments = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> addArguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDevEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            publicKey(model.publicKey);
            addPublicKeys(model.addPublicKeys);
            deletePublicKeys(model.deletePublicKeys);
            customLibraries(model.customLibraries);
            updateEtlLibraries(model.updateEtlLibraries);
            deleteArguments(model.deleteArguments);
            addArguments(model.addArguments);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final Collection<String> getAddPublicKeys() {
            if (addPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return addPublicKeys;
        }

        public final void setAddPublicKeys(Collection<String> addPublicKeys) {
            this.addPublicKeys = PublicKeysListCopier.copy(addPublicKeys);
        }

        @Override
        public final Builder addPublicKeys(Collection<String> addPublicKeys) {
            this.addPublicKeys = PublicKeysListCopier.copy(addPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addPublicKeys(String... addPublicKeys) {
            addPublicKeys(Arrays.asList(addPublicKeys));
            return this;
        }

        public final Collection<String> getDeletePublicKeys() {
            if (deletePublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return deletePublicKeys;
        }

        public final void setDeletePublicKeys(Collection<String> deletePublicKeys) {
            this.deletePublicKeys = PublicKeysListCopier.copy(deletePublicKeys);
        }

        @Override
        public final Builder deletePublicKeys(Collection<String> deletePublicKeys) {
            this.deletePublicKeys = PublicKeysListCopier.copy(deletePublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deletePublicKeys(String... deletePublicKeys) {
            deletePublicKeys(Arrays.asList(deletePublicKeys));
            return this;
        }

        public final DevEndpointCustomLibraries.Builder getCustomLibraries() {
            return customLibraries != null ? customLibraries.toBuilder() : null;
        }

        public final void setCustomLibraries(DevEndpointCustomLibraries.BuilderImpl customLibraries) {
            this.customLibraries = customLibraries != null ? customLibraries.build() : null;
        }

        @Override
        public final Builder customLibraries(DevEndpointCustomLibraries customLibraries) {
            this.customLibraries = customLibraries;
            return this;
        }

        public final Boolean getUpdateEtlLibraries() {
            return updateEtlLibraries;
        }

        public final void setUpdateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
        }

        @Override
        public final Builder updateEtlLibraries(Boolean updateEtlLibraries) {
            this.updateEtlLibraries = updateEtlLibraries;
            return this;
        }

        public final Collection<String> getDeleteArguments() {
            if (deleteArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return deleteArguments;
        }

        public final void setDeleteArguments(Collection<String> deleteArguments) {
            this.deleteArguments = StringListCopier.copy(deleteArguments);
        }

        @Override
        public final Builder deleteArguments(Collection<String> deleteArguments) {
            this.deleteArguments = StringListCopier.copy(deleteArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deleteArguments(String... deleteArguments) {
            deleteArguments(Arrays.asList(deleteArguments));
            return this;
        }

        public final Map<String, String> getAddArguments() {
            if (addArguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return addArguments;
        }

        public final void setAddArguments(Map<String, String> addArguments) {
            this.addArguments = MapValueCopier.copy(addArguments);
        }

        @Override
        public final Builder addArguments(Map<String, String> addArguments) {
            this.addArguments = MapValueCopier.copy(addArguments);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDevEndpointRequest build() {
            return new UpdateDevEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
