/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Action;
import software.amazon.awssdk.services.glue.model.ActionListCopier;
import software.amazon.awssdk.services.glue.model.EventBatchingCondition;
import software.amazon.awssdk.services.glue.model.Predicate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerUpdate> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TriggerUpdate.getter(TriggerUpdate::name)).setter(TriggerUpdate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TriggerUpdate.getter(TriggerUpdate::description)).setter(TriggerUpdate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schedule").getter(TriggerUpdate.getter(TriggerUpdate::schedule)).setter(TriggerUpdate.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(TriggerUpdate.getter(TriggerUpdate::actions)).setter(TriggerUpdate.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Predicate> PREDICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Predicate").getter(TriggerUpdate.getter(TriggerUpdate::predicate)).setter(TriggerUpdate.setter(Builder::predicate)).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predicate").build()}).build();
    private static final SdkField<EventBatchingCondition> EVENT_BATCHING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBatchingCondition").getter(TriggerUpdate.getter(TriggerUpdate::eventBatchingCondition)).setter(TriggerUpdate.setter(Builder::eventBatchingCondition)).constructor(EventBatchingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBatchingCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SCHEDULE_FIELD, ACTIONS_FIELD, PREDICATE_FIELD, EVENT_BATCHING_CONDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String schedule;
    private final List<Action> actions;
    private final Predicate predicate;
    private final EventBatchingCondition eventBatchingCondition;

    private TriggerUpdate(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.schedule = builder.schedule;
        this.actions = builder.actions;
        this.predicate = builder.predicate;
        this.eventBatchingCondition = builder.eventBatchingCondition;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String schedule() {
        return this.schedule;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public final Predicate predicate() {
        return this.predicate;
    }

    public final EventBatchingCondition eventBatchingCondition() {
        return this.eventBatchingCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predicate());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBatchingCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerUpdate)) {
            return false;
        }
        TriggerUpdate other = (TriggerUpdate)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.schedule(), other.schedule()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.predicate(), other.predicate()) && Objects.equals(this.eventBatchingCondition(), other.eventBatchingCondition());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerUpdate").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Schedule", (Object)this.schedule()).add("Actions", this.hasActions() ? this.actions() : null).add("Predicate", (Object)this.predicate()).add("EventBatchingCondition", (Object)this.eventBatchingCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "Predicate": {
                return Optional.ofNullable(clazz.cast(this.predicate()));
            }
            case "EventBatchingCondition": {
                return Optional.ofNullable(clazz.cast(this.eventBatchingCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerUpdate, T> g) {
        return obj -> g.apply((TriggerUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String schedule;
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private Predicate predicate;
        private EventBatchingCondition eventBatchingCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerUpdate model) {
            this.name(model.name);
            this.description(model.description);
            this.schedule(model.schedule);
            this.actions(model.actions);
            this.predicate(model.predicate);
            this.eventBatchingCondition(model.eventBatchingCondition);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Predicate.Builder getPredicate() {
            return this.predicate != null ? this.predicate.toBuilder() : null;
        }

        public final void setPredicate(Predicate.BuilderImpl predicate) {
            this.predicate = predicate != null ? predicate.build() : null;
        }

        @Override
        public final Builder predicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public final EventBatchingCondition.Builder getEventBatchingCondition() {
            return this.eventBatchingCondition != null ? this.eventBatchingCondition.toBuilder() : null;
        }

        public final void setEventBatchingCondition(EventBatchingCondition.BuilderImpl eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition != null ? eventBatchingCondition.build() : null;
        }

        @Override
        public final Builder eventBatchingCondition(EventBatchingCondition eventBatchingCondition) {
            this.eventBatchingCondition = eventBatchingCondition;
            return this;
        }

        public TriggerUpdate build() {
            return new TriggerUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerUpdate> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder schedule(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder predicate(Predicate var1);

        default public Builder predicate(Consumer<Predicate.Builder> predicate) {
            return this.predicate((Predicate)((Predicate.Builder)Predicate.builder().applyMutation(predicate)).build());
        }

        public Builder eventBatchingCondition(EventBatchingCondition var1);

        default public Builder eventBatchingCondition(Consumer<EventBatchingCondition.Builder> eventBatchingCondition) {
            return this.eventBatchingCondition((EventBatchingCondition)((EventBatchingCondition.Builder)EventBatchingCondition.builder().applyMutation(eventBatchingCondition)).build());
        }
    }
}

