/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataLakeAccessPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataLakeAccessPropertiesOutput> {
    private static final SdkField<Boolean> DATA_LAKE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DataLakeAccess").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::dataLakeAccess)).setter(DataLakeAccessPropertiesOutput.setter(Builder::dataLakeAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakeAccess").build()}).build();
    private static final SdkField<String> DATA_TRANSFER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTransferRole").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::dataTransferRole)).setter(DataLakeAccessPropertiesOutput.setter(Builder::dataTransferRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferRole").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::kmsKey)).setter(DataLakeAccessPropertiesOutput.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> MANAGED_WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedWorkgroupName").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::managedWorkgroupName)).setter(DataLakeAccessPropertiesOutput.setter(Builder::managedWorkgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedWorkgroupName").build()}).build();
    private static final SdkField<String> MANAGED_WORKGROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedWorkgroupStatus").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::managedWorkgroupStatus)).setter(DataLakeAccessPropertiesOutput.setter(Builder::managedWorkgroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedWorkgroupStatus").build()}).build();
    private static final SdkField<String> REDSHIFT_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftDatabaseName").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::redshiftDatabaseName)).setter(DataLakeAccessPropertiesOutput.setter(Builder::redshiftDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDatabaseName").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::statusMessage)).setter(DataLakeAccessPropertiesOutput.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> CATALOG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogType").getter(DataLakeAccessPropertiesOutput.getter(DataLakeAccessPropertiesOutput::catalogType)).setter(DataLakeAccessPropertiesOutput.setter(Builder::catalogType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_LAKE_ACCESS_FIELD, DATA_TRANSFER_ROLE_FIELD, KMS_KEY_FIELD, MANAGED_WORKGROUP_NAME_FIELD, MANAGED_WORKGROUP_STATUS_FIELD, REDSHIFT_DATABASE_NAME_FIELD, STATUS_MESSAGE_FIELD, CATALOG_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataLakeAccessPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean dataLakeAccess;
    private final String dataTransferRole;
    private final String kmsKey;
    private final String managedWorkgroupName;
    private final String managedWorkgroupStatus;
    private final String redshiftDatabaseName;
    private final String statusMessage;
    private final String catalogType;

    private DataLakeAccessPropertiesOutput(BuilderImpl builder) {
        this.dataLakeAccess = builder.dataLakeAccess;
        this.dataTransferRole = builder.dataTransferRole;
        this.kmsKey = builder.kmsKey;
        this.managedWorkgroupName = builder.managedWorkgroupName;
        this.managedWorkgroupStatus = builder.managedWorkgroupStatus;
        this.redshiftDatabaseName = builder.redshiftDatabaseName;
        this.statusMessage = builder.statusMessage;
        this.catalogType = builder.catalogType;
    }

    public final Boolean dataLakeAccess() {
        return this.dataLakeAccess;
    }

    public final String dataTransferRole() {
        return this.dataTransferRole;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String managedWorkgroupName() {
        return this.managedWorkgroupName;
    }

    public final String managedWorkgroupStatus() {
        return this.managedWorkgroupStatus;
    }

    public final String redshiftDatabaseName() {
        return this.redshiftDatabaseName;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String catalogType() {
        return this.catalogType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataLakeAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedWorkgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedWorkgroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeAccessPropertiesOutput)) {
            return false;
        }
        DataLakeAccessPropertiesOutput other = (DataLakeAccessPropertiesOutput)obj;
        return Objects.equals(this.dataLakeAccess(), other.dataLakeAccess()) && Objects.equals(this.dataTransferRole(), other.dataTransferRole()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.managedWorkgroupName(), other.managedWorkgroupName()) && Objects.equals(this.managedWorkgroupStatus(), other.managedWorkgroupStatus()) && Objects.equals(this.redshiftDatabaseName(), other.redshiftDatabaseName()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.catalogType(), other.catalogType());
    }

    public final String toString() {
        return ToString.builder((String)"DataLakeAccessPropertiesOutput").add("DataLakeAccess", (Object)this.dataLakeAccess()).add("DataTransferRole", (Object)this.dataTransferRole()).add("KmsKey", (Object)this.kmsKey()).add("ManagedWorkgroupName", (Object)this.managedWorkgroupName()).add("ManagedWorkgroupStatus", (Object)this.managedWorkgroupStatus()).add("RedshiftDatabaseName", (Object)this.redshiftDatabaseName()).add("StatusMessage", (Object)this.statusMessage()).add("CatalogType", (Object)this.catalogType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataLakeAccess": {
                return Optional.ofNullable(clazz.cast(this.dataLakeAccess()));
            }
            case "DataTransferRole": {
                return Optional.ofNullable(clazz.cast(this.dataTransferRole()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "ManagedWorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.managedWorkgroupName()));
            }
            case "ManagedWorkgroupStatus": {
                return Optional.ofNullable(clazz.cast(this.managedWorkgroupStatus()));
            }
            case "RedshiftDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.redshiftDatabaseName()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CatalogType": {
                return Optional.ofNullable(clazz.cast(this.catalogType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataLakeAccess", DATA_LAKE_ACCESS_FIELD);
        map.put("DataTransferRole", DATA_TRANSFER_ROLE_FIELD);
        map.put("KmsKey", KMS_KEY_FIELD);
        map.put("ManagedWorkgroupName", MANAGED_WORKGROUP_NAME_FIELD);
        map.put("ManagedWorkgroupStatus", MANAGED_WORKGROUP_STATUS_FIELD);
        map.put("RedshiftDatabaseName", REDSHIFT_DATABASE_NAME_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CatalogType", CATALOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataLakeAccessPropertiesOutput, T> g) {
        return obj -> g.apply((DataLakeAccessPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean dataLakeAccess;
        private String dataTransferRole;
        private String kmsKey;
        private String managedWorkgroupName;
        private String managedWorkgroupStatus;
        private String redshiftDatabaseName;
        private String statusMessage;
        private String catalogType;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeAccessPropertiesOutput model) {
            this.dataLakeAccess(model.dataLakeAccess);
            this.dataTransferRole(model.dataTransferRole);
            this.kmsKey(model.kmsKey);
            this.managedWorkgroupName(model.managedWorkgroupName);
            this.managedWorkgroupStatus(model.managedWorkgroupStatus);
            this.redshiftDatabaseName(model.redshiftDatabaseName);
            this.statusMessage(model.statusMessage);
            this.catalogType(model.catalogType);
        }

        public final Boolean getDataLakeAccess() {
            return this.dataLakeAccess;
        }

        public final void setDataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
        }

        @Override
        public final Builder dataLakeAccess(Boolean dataLakeAccess) {
            this.dataLakeAccess = dataLakeAccess;
            return this;
        }

        public final String getDataTransferRole() {
            return this.dataTransferRole;
        }

        public final void setDataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
        }

        @Override
        public final Builder dataTransferRole(String dataTransferRole) {
            this.dataTransferRole = dataTransferRole;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getManagedWorkgroupName() {
            return this.managedWorkgroupName;
        }

        public final void setManagedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
        }

        @Override
        public final Builder managedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
            return this;
        }

        public final String getManagedWorkgroupStatus() {
            return this.managedWorkgroupStatus;
        }

        public final void setManagedWorkgroupStatus(String managedWorkgroupStatus) {
            this.managedWorkgroupStatus = managedWorkgroupStatus;
        }

        @Override
        public final Builder managedWorkgroupStatus(String managedWorkgroupStatus) {
            this.managedWorkgroupStatus = managedWorkgroupStatus;
            return this;
        }

        public final String getRedshiftDatabaseName() {
            return this.redshiftDatabaseName;
        }

        public final void setRedshiftDatabaseName(String redshiftDatabaseName) {
            this.redshiftDatabaseName = redshiftDatabaseName;
        }

        @Override
        public final Builder redshiftDatabaseName(String redshiftDatabaseName) {
            this.redshiftDatabaseName = redshiftDatabaseName;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCatalogType() {
            return this.catalogType;
        }

        public final void setCatalogType(String catalogType) {
            this.catalogType = catalogType;
        }

        @Override
        public final Builder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        public DataLakeAccessPropertiesOutput build() {
            return new DataLakeAccessPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataLakeAccessPropertiesOutput> {
        public Builder dataLakeAccess(Boolean var1);

        public Builder dataTransferRole(String var1);

        public Builder kmsKey(String var1);

        public Builder managedWorkgroupName(String var1);

        public Builder managedWorkgroupStatus(String var1);

        public Builder redshiftDatabaseName(String var1);

        public Builder statusMessage(String var1);

        public Builder catalogType(String var1);
    }
}

